/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.builder;

import com.tangzc.autotable.core.builder.ColumnMetadataBuilder;
import com.tangzc.autotable.core.builder.IndexMetadataBuilder;
import com.tangzc.autotable.core.strategy.ColumnMetadata;
import com.tangzc.autotable.core.strategy.DefaultTableMetadata;
import com.tangzc.autotable.core.strategy.IndexMetadata;
import com.tangzc.autotable.core.utils.BeanClassUtil;
import com.tangzc.autotable.core.utils.TableBeanUtils;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableMetadataBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultTableMetadataBuilder.class);
    protected final ColumnMetadataBuilder columnMetadataBuilder;
    protected final IndexMetadataBuilder indexMetadataBuilder;

    public DefaultTableMetadataBuilder(ColumnMetadataBuilder columnMetadataBuilder, IndexMetadataBuilder indexMetadataBuilder) {
        this.columnMetadataBuilder = columnMetadataBuilder;
        this.indexMetadataBuilder = indexMetadataBuilder;
    }

    public DefaultTableMetadata build(Class<?> clazz) {
        String tableName = this.getTableName(clazz);
        String tableSchema = this.getTableSchema(clazz);
        String tableComment = this.getTableComment(clazz);
        DefaultTableMetadata tableMetadata = new DefaultTableMetadata(clazz, tableName, tableSchema, tableComment);
        List<Field> fields = BeanClassUtil.listAllFieldForColumn(clazz);
        this.fillColumnMetadataList(clazz, tableMetadata, fields);
        this.fillIndexMetadataList(clazz, tableMetadata, fields);
        return tableMetadata;
    }

    protected String getTableComment(Class<?> clazz) {
        return TableBeanUtils.getTableComment(clazz);
    }

    protected String getTableSchema(Class<?> clazz) {
        return TableBeanUtils.getTableSchema(clazz);
    }

    protected String getTableName(Class<?> clazz) {
        return TableBeanUtils.getTableName(clazz);
    }

    protected void fillIndexMetadataList(Class<?> clazz, DefaultTableMetadata tableMetadata, List<Field> fields) {
        List<IndexMetadata> indexMetadataList = this.indexMetadataBuilder.buildList(clazz, fields);
        tableMetadata.setIndexMetadataList(indexMetadataList);
    }

    protected void fillColumnMetadataList(Class<?> clazz, DefaultTableMetadata tableMetadata, List<Field> fields) {
        List<ColumnMetadata> columnMetadataList = this.columnMetadataBuilder.buildList(clazz, fields);
        tableMetadata.setColumnMetadataList(columnMetadataList);
    }
}

