/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.dynamicds;

import lombok.NonNull;
import org.apache.ibatis.session.SqlSessionFactory;

public class SqlSessionFactoryManager {
    private static final ThreadLocal<SqlSessionFactory> SQL_SESSION_FACTORY = new ThreadLocal();

    public static void setSqlSessionFactory(@NonNull SqlSessionFactory sqlSessionFactory) {
        if (sqlSessionFactory == null) {
            throw new NullPointerException("sqlSessionFactory is marked non-null but is null");
        }
        SQL_SESSION_FACTORY.set(sqlSessionFactory);
    }

    public static SqlSessionFactory getSqlSessionFactory() {
        SqlSessionFactory sessionFactory = SQL_SESSION_FACTORY.get();
        if (sessionFactory == null) {
            throw new RuntimeException("\u5f53\u524d\u6570\u636e\u6e90\u4e0b\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684SqlSessionFactory");
        }
        return sessionFactory;
    }

    public static void cleanSqlSessionFactory() {
        SQL_SESSION_FACTORY.remove();
    }
}

