/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.recordsql;

import com.tangzc.autotable.core.AutoTableGlobalConfig;
import com.tangzc.autotable.core.config.PropertyConfig;
import com.tangzc.autotable.core.dynamicds.DatasourceNameManager;
import com.tangzc.autotable.core.dynamicds.IDataSourceHandler;
import com.tangzc.autotable.core.dynamicds.SqlSessionFactoryManager;
import com.tangzc.autotable.core.recordsql.AutoTableExecuteSqlLog;
import com.tangzc.autotable.core.recordsql.RecordSqlHandler;
import com.tangzc.autotable.core.strategy.IStrategy;
import com.tangzc.autotable.core.utils.StringUtils;
import com.tangzc.autotable.core.utils.TableBeanUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordSqlDbHandler
implements RecordSqlHandler {
    private static final Logger log = LoggerFactory.getLogger(RecordSqlDbHandler.class);

    @Override
    public void record(AutoTableExecuteSqlLog autoTableExecuteSqlLog) {
        PropertyConfig.RecordSqlProperties recordSqlConfig = AutoTableGlobalConfig.getAutoTableProperties().getRecordSql();
        String tableName = recordSqlConfig.getTableName();
        if (StringUtils.noText(tableName)) {
            tableName = TableBeanUtils.getTableName(AutoTableExecuteSqlLog.class);
        }
        SqlSessionFactory sqlSessionFactory = SqlSessionFactoryManager.getSqlSessionFactory();
        try (SqlSession sqlSession = sqlSessionFactory.openSession();
             Connection connection = sqlSession.getConnection();){
            boolean tableNotExit = !connection.getMetaData().getTables(null, null, tableName, null).next();
            connection.setAutoCommit(false);
            if (tableNotExit) {
                RecordSqlDbHandler.initTable(connection);
            }
            RecordSqlDbHandler.insertLog(tableName, autoTableExecuteSqlLog, connection);
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void insertLog(String tableName, AutoTableExecuteSqlLog autoTableExecuteSqlLog, Connection connection) throws SQLException {
        Class<AutoTableExecuteSqlLog> sqlLogClass = AutoTableExecuteSqlLog.class;
        List columnFields = Arrays.stream(sqlLogClass.getDeclaredFields()).filter(field -> TableBeanUtils.isIncludeField(field, sqlLogClass)).collect(Collectors.toList());
        List columns = columnFields.stream().map(field -> TableBeanUtils.getRealColumnName(sqlLogClass, field)).collect(Collectors.toList());
        List values = columnFields.stream().map(field -> {
            try {
                field.setAccessible(true);
                return field.get(autoTableExecuteSqlLog);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        String insertSql = String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, String.join((CharSequence)", ", columns), IntStream.range(0, values.size()).mapToObj(i -> "?").collect(Collectors.joining(", ")));
        log.info("\u63d2\u5165SQL\u8bb0\u5f55\uff1a{}", (Object)insertSql);
        PreparedStatement preparedStatement = connection.prepareStatement(insertSql);
        for (int i2 = 0; i2 < values.size(); ++i2) {
            preparedStatement.setObject(i2 + 1, values.get(i2));
        }
        preparedStatement.executeUpdate();
    }

    private static void initTable(Connection connection) throws SQLException {
        IDataSourceHandler datasourceHandler = AutoTableGlobalConfig.getDatasourceHandler();
        String datasourceName = DatasourceNameManager.getDatasourceName();
        String databaseDialect = datasourceHandler.getDatabaseDialect(datasourceName);
        IStrategy<?, ?, ?> createTableStrategy = AutoTableGlobalConfig.getStrategy(databaseDialect);
        List<String> initTableSql = createTableStrategy.createTable(AutoTableExecuteSqlLog.class);
        try (Statement statement = connection.createStatement();){
            for (String sql : initTableSql) {
                statement.execute(sql);
            }
        }
    }
}

