/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.recordsql;

import com.tangzc.autotable.core.AutoTableGlobalConfig;
import com.tangzc.autotable.core.config.PropertyConfig;
import com.tangzc.autotable.core.dynamicds.DatasourceNameManager;
import com.tangzc.autotable.core.recordsql.AutoTableExecuteSqlLog;
import com.tangzc.autotable.core.recordsql.RecordSqlHandler;
import com.tangzc.autotable.core.utils.StringUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordSqlFileHandler
implements RecordSqlHandler {
    private static final Logger log = LoggerFactory.getLogger(RecordSqlFileHandler.class);

    @Override
    public void record(AutoTableExecuteSqlLog autoTableExecuteSqlLog) {
        PropertyConfig.RecordSqlProperties recordSql = AutoTableGlobalConfig.getAutoTableProperties().getRecordSql();
        String folderPath = recordSql.getFolderPath();
        Path path = this.getFilePath(folderPath, autoTableExecuteSqlLog);
        if (path != null) {
            try {
                String sqlStatement = autoTableExecuteSqlLog.getSqlStatement();
                if (!sqlStatement.endsWith(";")) {
                    sqlStatement = sqlStatement + ";";
                }
                if (!sqlStatement.endsWith(System.lineSeparator())) {
                    sqlStatement = sqlStatement + System.lineSeparator();
                }
                Files.write(path, sqlStatement.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                log.error("\u5411{}\u5199\u5165SQL\u65e5\u5fd7\u51fa\u9519", (Object)path, (Object)e);
            }
        }
    }

    protected Path getFilePath(String folderPath, AutoTableExecuteSqlLog autoTableExecuteSqlLog) {
        if (StringUtils.noText(folderPath)) {
            log.error("\u6ca1\u6709\u6307\u5b9aSQL\u65e5\u5fd7\u6587\u4ef6\u76ee\u5f55\uff0c\u65e0\u6cd5\u8bb0\u5f55SQL\u6267\u884c\u8bb0\u5f55");
            return null;
        }
        String fileName = this.getFileName(autoTableExecuteSqlLog);
        Path path = Paths.get(folderPath, fileName);
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.createFile(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error("\u521b\u5efa\u65e5\u5fd7\u6587\u4ef6{}\u51fa\u9519", (Object)path, (Object)e);
                return null;
            }
        }
        return path;
    }

    protected String getFileName(AutoTableExecuteSqlLog autoTableExecuteSqlLog) {
        String tableSchema;
        String dataSourceName;
        StringBuilder fileName = new StringBuilder();
        if (StringUtils.hasText(autoTableExecuteSqlLog.getVersion())) {
            fileName.append(autoTableExecuteSqlLog.getVersion()).append("_");
        }
        if (StringUtils.hasText(dataSourceName = DatasourceNameManager.getDatasourceName())) {
            fileName.append(dataSourceName).append("_");
        }
        if (StringUtils.hasText(tableSchema = autoTableExecuteSqlLog.getTableSchema())) {
            fileName.append(tableSchema).append("_");
        }
        fileName.append(autoTableExecuteSqlLog.getTableName());
        return fileName.append(".sql").toString();
    }
}

