/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.strategy.mysql.builder;

import com.tangzc.autotable.annotation.enums.DefaultValueEnum;
import com.tangzc.autotable.core.strategy.mysql.data.MysqlColumnMetadata;
import com.tangzc.autotable.core.strategy.mysql.data.MysqlTypeHelper;
import com.tangzc.autotable.core.utils.StringConnectHelper;
import com.tangzc.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(ColumnSqlBuilder.class);

    public static String buildSql(MysqlColumnMetadata columnMetadata) {
        return StringConnectHelper.newInstance("`{columnName}` {typeAndLength} {character} {collate} {null} {default} {autoIncrement} {columnComment} {position}").replace("{columnName}", columnMetadata.getName()).replace("{typeAndLength}", MysqlTypeHelper.getFullType(columnMetadata.getType())).replace("{character}", () -> {
            String characterSet = columnMetadata.getCharacterSet();
            if (StringUtils.hasText(characterSet)) {
                return "CHARACTER SET " + characterSet;
            }
            return "";
        }).replace("{collate}", () -> {
            String collate = columnMetadata.getCollate();
            if (StringUtils.hasText(collate)) {
                return "COLLATE " + collate;
            }
            return "";
        }).replace("{null}", columnMetadata.isNotNull() ? "NOT NULL" : "NULL").replace("{default}", () -> {
            DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
            if (defaultValueType == DefaultValueEnum.NULL) {
                return "DEFAULT NULL";
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return "DEFAULT ''";
            }
            String defaultValue = columnMetadata.getDefaultValue();
            if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText(defaultValue)) {
                return "DEFAULT " + defaultValue;
            }
            return "";
        }).replace("{autoIncrement}", columnMetadata.isAutoIncrement() ? "AUTO_INCREMENT" : "").replace("{columnComment}", StringUtils.hasText(columnMetadata.getComment()) ? "COMMENT '" + columnMetadata.getComment() + "'" : "").replace("{position}", () -> {
            if (StringUtils.hasText(columnMetadata.getNewPreColumn())) {
                return "AFTER `" + columnMetadata.getNewPreColumn() + "`";
            }
            if ("".equals(columnMetadata.getNewPreColumn())) {
                return "FIRST";
            }
            return "";
        }).toString();
    }
}

