/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.strategy.mysql.builder;

import com.tangzc.autotable.annotation.mysql.MysqlCharset;
import com.tangzc.autotable.annotation.mysql.MysqlEngine;
import com.tangzc.autotable.core.AutoTableGlobalConfig;
import com.tangzc.autotable.core.builder.IndexMetadataBuilder;
import com.tangzc.autotable.core.config.PropertyConfig;
import com.tangzc.autotable.core.strategy.IndexMetadata;
import com.tangzc.autotable.core.strategy.mysql.builder.MysqlColumnMetadataBuilder;
import com.tangzc.autotable.core.strategy.mysql.data.MysqlColumnMetadata;
import com.tangzc.autotable.core.strategy.mysql.data.MysqlTableMetadata;
import com.tangzc.autotable.core.utils.BeanClassUtil;
import com.tangzc.autotable.core.utils.StringUtils;
import com.tangzc.autotable.core.utils.TableBeanUtils;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlTableMetadataBuilder {
    private static final Logger log = LoggerFactory.getLogger(MysqlTableMetadataBuilder.class);

    public static MysqlTableMetadata build(Class<?> clazz) {
        MysqlEngine mysqlEngine;
        String collate;
        String charset;
        String tableName = TableBeanUtils.getTableName(clazz);
        String tableComment = TableBeanUtils.getTableComment(clazz);
        MysqlTableMetadata mysqlTableMetadata = new MysqlTableMetadata(clazz, tableName, tableComment);
        MysqlCharset mysqlCharsetAnno = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(clazz, MysqlCharset.class);
        if (mysqlCharsetAnno != null) {
            charset = mysqlCharsetAnno.charset();
            collate = mysqlCharsetAnno.collate();
        } else {
            PropertyConfig autoTableProperties = AutoTableGlobalConfig.getAutoTableProperties();
            charset = autoTableProperties.getMysql().getTableDefaultCharset();
            collate = autoTableProperties.getMysql().getTableDefaultCollation();
        }
        if (StringUtils.hasText(charset) && StringUtils.hasText(collate)) {
            mysqlTableMetadata.setCharacterSet(charset);
            mysqlTableMetadata.setCollate(collate);
        }
        if ((mysqlEngine = AutoTableGlobalConfig.getAutoTableAnnotationFinder().find(clazz, MysqlEngine.class)) != null) {
            mysqlTableMetadata.setEngine(mysqlEngine.value());
        }
        List<Field> fields = BeanClassUtil.listAllFieldForColumn(clazz);
        List<MysqlColumnMetadata> columnMetadataList = new MysqlColumnMetadataBuilder().buildList(clazz, fields);
        mysqlTableMetadata.setColumnMetadataList(columnMetadataList);
        List<IndexMetadata> indexMetadataList = new IndexMetadataBuilder().buildList(clazz, fields);
        mysqlTableMetadata.setIndexMetadataList(indexMetadataList);
        return mysqlTableMetadata;
    }
}

