/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.strategy.mysql.data;

import com.tangzc.autotable.core.converter.DatabaseTypeAndLength;
import com.tangzc.autotable.core.strategy.mysql.data.MySqlDefaultTypeEnum;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class MysqlTypeHelper {
    public static final Set<String> CHAR_STRING_TYPE = new HashSet<String>(Arrays.asList(MySqlDefaultTypeEnum.CHAR.getTypeName(), MySqlDefaultTypeEnum.VARCHAR.getTypeName(), MySqlDefaultTypeEnum.TEXT.getTypeName(), MySqlDefaultTypeEnum.TINYTEXT.getTypeName(), MySqlDefaultTypeEnum.MEDIUMTEXT.getTypeName(), MySqlDefaultTypeEnum.LONGTEXT.getTypeName(), MySqlDefaultTypeEnum.ENUM.getTypeName(), MySqlDefaultTypeEnum.SET.getTypeName()));
    public static final Set<String> ENUM_OR_SET_TYPE = new HashSet<String>(Arrays.asList(MySqlDefaultTypeEnum.ENUM.getTypeName(), MySqlDefaultTypeEnum.SET.getTypeName()));
    public static final Set<String> DATE_TIME_TYPE = new HashSet<String>(Arrays.asList(MySqlDefaultTypeEnum.DATE.getTypeName(), MySqlDefaultTypeEnum.DATETIME.getTypeName(), MySqlDefaultTypeEnum.YEAR.getTypeName(), MySqlDefaultTypeEnum.TIME.getTypeName()));
    public static final Set<String> INTEGER_TYPE = new HashSet<String>(Arrays.asList(MySqlDefaultTypeEnum.INT.getTypeName(), MySqlDefaultTypeEnum.TINYINT.getTypeName(), MySqlDefaultTypeEnum.SMALLINT.getTypeName(), MySqlDefaultTypeEnum.MEDIUMINT.getTypeName(), MySqlDefaultTypeEnum.BIGINT.getTypeName()));
    public static final Set<String> FLOAT_TYPE = new HashSet<String>(Arrays.asList(MySqlDefaultTypeEnum.FLOAT.getTypeName(), MySqlDefaultTypeEnum.DOUBLE.getTypeName(), MySqlDefaultTypeEnum.DECIMAL.getTypeName()));

    public static String getFullType(DatabaseTypeAndLength databaseTypeAndLength) {
        String typeAndLength = databaseTypeAndLength.getType();
        Integer length = databaseTypeAndLength.getLength();
        Integer decimalLength = databaseTypeAndLength.getDecimalLength();
        if (MysqlTypeHelper.isEnum(databaseTypeAndLength)) {
            typeAndLength = typeAndLength + "('" + String.join((CharSequence)"','", databaseTypeAndLength.getValues()) + "')";
        } else if (length != null) {
            typeAndLength = typeAndLength + "(" + length;
            if (decimalLength != null) {
                typeAndLength = typeAndLength + "," + decimalLength;
            }
            typeAndLength = typeAndLength + ")";
        }
        return typeAndLength;
    }

    public static boolean isCharString(DatabaseTypeAndLength databaseTypeAndLength) {
        return CHAR_STRING_TYPE.contains(databaseTypeAndLength.getType());
    }

    public static boolean isDateTime(DatabaseTypeAndLength databaseTypeAndLength) {
        return DATE_TIME_TYPE.contains(databaseTypeAndLength.getType());
    }

    public static boolean needStringCompatibility(DatabaseTypeAndLength databaseTypeAndLength) {
        return MysqlTypeHelper.isCharString(databaseTypeAndLength) || MysqlTypeHelper.isDateTime(databaseTypeAndLength);
    }

    public static boolean isBoolean(DatabaseTypeAndLength databaseTypeAndLength) {
        return MySqlDefaultTypeEnum.BIT.getTypeName().equalsIgnoreCase(databaseTypeAndLength.getType());
    }

    public static boolean isNumber(DatabaseTypeAndLength databaseTypeAndLength) {
        return INTEGER_TYPE.contains(databaseTypeAndLength.getType()) || FLOAT_TYPE.contains(databaseTypeAndLength.getType());
    }

    public static boolean isEnum(DatabaseTypeAndLength databaseTypeAndLength) {
        return ENUM_OR_SET_TYPE.contains(databaseTypeAndLength.getType());
    }

    public static boolean isFloatNumber(DatabaseTypeAndLength databaseTypeAndLength) {
        return FLOAT_TYPE.contains(databaseTypeAndLength.getType());
    }

    public static boolean isNoLengthNumber(DatabaseTypeAndLength databaseTypeAndLength) {
        return INTEGER_TYPE.contains(databaseTypeAndLength.getType());
    }
}

