/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.strategy.pgsql.builder;

import com.tangzc.autotable.annotation.enums.DefaultValueEnum;
import com.tangzc.autotable.core.strategy.ColumnMetadata;
import com.tangzc.autotable.core.strategy.pgsql.data.PgsqlTypeHelper;
import com.tangzc.autotable.core.utils.StringConnectHelper;
import com.tangzc.autotable.core.utils.StringUtils;

public class ColumnSqlBuilder {
    public static String buildSql(ColumnMetadata columnMetadata) {
        return StringConnectHelper.newInstance("{columnName} {typeAndLength} {null} {default}").replace("{columnName}", columnMetadata.getName()).replace("{typeAndLength}", () -> {
            if (columnMetadata.isAutoIncrement()) {
                return "serial";
            }
            return PgsqlTypeHelper.getFullType(columnMetadata.getType());
        }).replace("{null}", columnMetadata.isNotNull() ? "NOT NULL" : "").replace("{default}", () -> {
            DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
            if (defaultValueType == DefaultValueEnum.NULL) {
                return "DEFAULT NULL";
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return "DEFAULT ''";
            }
            String defaultValue = columnMetadata.getDefaultValue();
            if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText(defaultValue)) {
                return "DEFAULT " + defaultValue;
            }
            return "";
        }).toString();
    }
}

