/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.strategy.pgsql.builder;

import com.tangzc.autotable.annotation.enums.IndexTypeEnum;
import com.tangzc.autotable.core.strategy.ColumnMetadata;
import com.tangzc.autotable.core.strategy.DefaultTableMetadata;
import com.tangzc.autotable.core.strategy.IndexMetadata;
import com.tangzc.autotable.core.strategy.pgsql.PgsqlStrategy;
import com.tangzc.autotable.core.strategy.pgsql.builder.ColumnSqlBuilder;
import com.tangzc.autotable.core.utils.StringConnectHelper;
import com.tangzc.autotable.core.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(CreateTableSqlBuilder.class);

    public static String buildSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String tableName = tableMetadata.getTableName();
        String createTableSql = CreateTableSqlBuilder.getCreateTableSql(tableMetadata);
        List<IndexMetadata> indexMetadataList = tableMetadata.getIndexMetadataList();
        String createIndexSql = CreateTableSqlBuilder.getCreateIndexSql(schema, tableName, indexMetadataList);
        String addCommentSql = CreateTableSqlBuilder.getAddColumnCommentSql(tableMetadata);
        return createTableSql + "\n" + createIndexSql + "\n" + addCommentSql;
    }

    public static String getCreateIndexSql(String schema, String tableName, List<IndexMetadata> indexMetadataList) {
        return indexMetadataList.stream().map(pgsqlIndexMetadata -> StringConnectHelper.newInstance("CREATE {indexType} INDEX {indexName} ON {tableName} ({columns});").replace("{indexType}", pgsqlIndexMetadata.getType() == IndexTypeEnum.UNIQUE ? "UNIQUE" : "").replace("{indexName}", pgsqlIndexMetadata.getName()).replace("{tableName}", PgsqlStrategy.withSchemaName(schema, tableName)).replace("{columns}", () -> {
            List<IndexMetadata.IndexColumnParam> columnParams = pgsqlIndexMetadata.getColumns();
            return columnParams.stream().map(column -> "{column} {sortMode}".replace("{column}", column.getColumn()).replace("{sortMode}", column.getSort() != null ? column.getSort().name() : "")).collect(Collectors.joining(","));
        }).toString()).collect(Collectors.joining("\n"));
    }

    private static String getAddColumnCommentSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String tableName = tableMetadata.getTableName();
        String comment = tableMetadata.getComment();
        List<ColumnMetadata> columnMetadataList = tableMetadata.getColumnMetadataList();
        List<IndexMetadata> indexMetadataList = tableMetadata.getIndexMetadataList();
        return CreateTableSqlBuilder.getAddColumnCommentSql(schema, tableName, comment, columnMetadataList.stream().collect(Collectors.toMap(ColumnMetadata::getName, ColumnMetadata::getComment)), indexMetadataList.stream().collect(Collectors.toMap(IndexMetadata::getName, IndexMetadata::getComment)));
    }

    public static String getAddColumnCommentSql(String schema, String tableName, String tableComment, Map<String, String> columnCommentMap, Map<String, String> indexCommentMap) {
        ArrayList<String> commentList = new ArrayList<String>();
        if (StringUtils.hasText(tableComment)) {
            String addTableComment = "COMMENT ON TABLE {tableName} IS '{comment}';".replace("{tableName}", PgsqlStrategy.withSchemaName(schema, tableName)).replace("{comment}", tableComment);
            commentList.add(addTableComment);
        }
        columnCommentMap.entrySet().stream().map(columnComment -> "COMMENT ON COLUMN {tableName}.{name} IS '{comment}';".replace("{tableName}", PgsqlStrategy.withSchemaName(schema, tableName)).replace("{name}", (CharSequence)columnComment.getKey()).replace("{comment}", (CharSequence)columnComment.getValue())).forEach(commentList::add);
        indexCommentMap.entrySet().stream().map(indexComment -> "COMMENT ON INDEX {name} IS '{comment}';".replace("{name}", PgsqlStrategy.withSchemaName(schema, (String)indexComment.getKey())).replace("{comment}", (CharSequence)indexComment.getValue())).forEach(commentList::add);
        return String.join((CharSequence)"\n", commentList);
    }

    private static String getCreateTableSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String name = tableMetadata.getTableName();
        List<ColumnMetadata> columnMetadataList = tableMetadata.getColumnMetadataList();
        ArrayList<String> columnList = new ArrayList<String>();
        ArrayList<String> primaries = new ArrayList<String>();
        columnMetadataList.forEach(columnData -> {
            if (columnData.isPrimary()) {
                columnData.setNotNull(true);
                primaries.add(columnData.getName());
            }
        });
        columnList.add(columnMetadataList.stream().map(ColumnSqlBuilder::buildSql).collect(Collectors.joining(",")));
        if (!primaries.isEmpty()) {
            String primaryKeySql = CreateTableSqlBuilder.getPrimaryKeySql(primaries);
            columnList.add(primaryKeySql);
        }
        String addSql = columnList.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        return "CREATE TABLE {tableName} ({columnList});".replace("{tableName}", PgsqlStrategy.withSchemaName(schema, name)).replace("{columnList}", addSql);
    }

    private static String getPrimaryKeySql(List<String> primaries) {
        return "PRIMARY KEY ({primaries})".replace("{primaries}", String.join((CharSequence)",", primaries));
    }
}

