/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.strategy.sqlite;

import com.tangzc.autotable.core.converter.DefaultTypeEnumInterface;
import com.tangzc.autotable.core.strategy.DefaultTableMetadata;
import com.tangzc.autotable.core.strategy.IStrategy;
import com.tangzc.autotable.core.strategy.IndexMetadata;
import com.tangzc.autotable.core.strategy.sqlite.builder.CreateTableSqlBuilder;
import com.tangzc.autotable.core.strategy.sqlite.builder.SqliteTableMetadataBuilder;
import com.tangzc.autotable.core.strategy.sqlite.data.SqliteCompareTableInfo;
import com.tangzc.autotable.core.strategy.sqlite.data.SqliteDefaultTypeEnum;
import com.tangzc.autotable.core.strategy.sqlite.data.dbdata.SqliteMaster;
import com.tangzc.autotable.core.strategy.sqlite.mapper.SqliteTablesMapper;
import com.tangzc.autotable.core.utils.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;

public class SqliteStrategy
implements IStrategy<DefaultTableMetadata, SqliteCompareTableInfo, SqliteTablesMapper> {
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");

    @Override
    public String databaseDialect() {
        return "SQLite";
    }

    @Override
    public Map<Class<?>, DefaultTypeEnumInterface> typeMapping() {
        return new HashMap<Class<?>, DefaultTypeEnumInterface>(32){
            {
                this.put(String.class, SqliteDefaultTypeEnum.TEXT);
                this.put(Character.class, SqliteDefaultTypeEnum.TEXT);
                this.put(Character.TYPE, SqliteDefaultTypeEnum.TEXT);
                this.put(BigInteger.class, SqliteDefaultTypeEnum.INTEGER);
                this.put(Long.class, SqliteDefaultTypeEnum.INTEGER);
                this.put(Long.TYPE, SqliteDefaultTypeEnum.INTEGER);
                this.put(Integer.class, SqliteDefaultTypeEnum.INTEGER);
                this.put(Integer.TYPE, SqliteDefaultTypeEnum.INTEGER);
                this.put(Boolean.class, SqliteDefaultTypeEnum.INTEGER);
                this.put(Boolean.TYPE, SqliteDefaultTypeEnum.INTEGER);
                this.put(Float.class, SqliteDefaultTypeEnum.REAL);
                this.put(Float.TYPE, SqliteDefaultTypeEnum.REAL);
                this.put(Double.class, SqliteDefaultTypeEnum.REAL);
                this.put(Double.TYPE, SqliteDefaultTypeEnum.REAL);
                this.put(BigDecimal.class, SqliteDefaultTypeEnum.REAL);
                this.put(java.util.Date.class, SqliteDefaultTypeEnum.TEXT);
                this.put(Date.class, SqliteDefaultTypeEnum.TEXT);
                this.put(Timestamp.class, SqliteDefaultTypeEnum.TEXT);
                this.put(Time.class, SqliteDefaultTypeEnum.TEXT);
                this.put(LocalDateTime.class, SqliteDefaultTypeEnum.TEXT);
                this.put(LocalDate.class, SqliteDefaultTypeEnum.TEXT);
                this.put(LocalTime.class, SqliteDefaultTypeEnum.TEXT);
                this.put(Short.class, SqliteDefaultTypeEnum.INTEGER);
                this.put(Short.TYPE, SqliteDefaultTypeEnum.INTEGER);
            }
        };
    }

    @Override
    public String dropTable(String schema, String tableName) {
        return String.format("drop table if exists `%s`;", tableName);
    }

    @Override
    @NonNull
    public DefaultTableMetadata analyseClass(Class<?> beanClass) {
        return new SqliteTableMetadataBuilder().build(beanClass);
    }

    @Override
    public List<String> createTable(DefaultTableMetadata tableMetadata) {
        ArrayList<String> sqlList = new ArrayList<String>();
        String createTableSql = CreateTableSqlBuilder.buildTableSql(tableMetadata.getTableName(), tableMetadata.getComment(), tableMetadata.getColumnMetadataList());
        sqlList.add(createTableSql);
        List<String> createIndexSqlList = CreateTableSqlBuilder.buildIndexSql(tableMetadata.getTableName(), tableMetadata.getIndexMetadataList());
        sqlList.addAll(createIndexSqlList);
        return sqlList;
    }

    @Override
    @NonNull
    public SqliteCompareTableInfo compareTable(DefaultTableMetadata tableMetadata) {
        boolean needRebuildTable;
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        SqliteCompareTableInfo sqliteCompareTableInfo = new SqliteCompareTableInfo(tableName, schema);
        String orgBuildTableSql = this.executeReturn(sqliteTablesMapper -> sqliteTablesMapper.queryBuildTableSql(tableName));
        String newBuildTableSql = CreateTableSqlBuilder.buildTableSql(tableMetadata.getTableName(), tableMetadata.getComment(), tableMetadata.getColumnMetadataList());
        boolean bl = needRebuildTable = !Objects.equals(orgBuildTableSql + ";", newBuildTableSql);
        if (needRebuildTable) {
            sqliteCompareTableInfo.setRebuildTableSql(newBuildTableSql);
            List orgBuildIndexSqlList = this.executeReturn(sqliteTablesMapper -> sqliteTablesMapper.queryBuildIndexSql(tableName));
            for (Object sqliteMaster : orgBuildIndexSqlList) {
                sqliteCompareTableInfo.getDeleteIndexList().add(((SqliteMaster)sqliteMaster).getName());
            }
            List<String> buildIndexSqlList = CreateTableSqlBuilder.buildIndexSql(tableName, tableMetadata.getIndexMetadataList());
            for (String buildIndexSql : buildIndexSqlList) {
                sqliteCompareTableInfo.getBuildIndexSqlList().add(buildIndexSql);
            }
        } else {
            Map<String, String> rebuildIndexMap = tableMetadata.getIndexMetadataList().stream().collect(Collectors.toMap(IndexMetadata::getName, indexMetadata -> CreateTableSqlBuilder.getIndexSql(tableName, indexMetadata)));
            List orgBuildIndexSqlList = this.executeReturn(sqliteTablesMapper -> sqliteTablesMapper.queryBuildIndexSql(tableName));
            for (SqliteMaster sqliteMaster : orgBuildIndexSqlList) {
                boolean exit;
                String indexName = sqliteMaster.getName();
                String newBuildIndexSql = rebuildIndexMap.remove(indexName);
                boolean bl2 = exit = newBuildIndexSql != null;
                if (!exit) {
                    sqliteCompareTableInfo.getDeleteIndexList().add(indexName);
                }
                String createIndexSqlRecord = sqliteMaster.getSql() + ";";
                if (!exit || Objects.equals(newBuildIndexSql, createIndexSqlRecord)) continue;
                sqliteCompareTableInfo.getDeleteIndexList().add(indexName);
                sqliteCompareTableInfo.getBuildIndexSqlList().add(newBuildIndexSql);
            }
            Map<String, String> needNewIndexes = rebuildIndexMap;
            if (!needNewIndexes.isEmpty()) {
                sqliteCompareTableInfo.getBuildIndexSqlList().addAll(needNewIndexes.values());
            }
        }
        return sqliteCompareTableInfo;
    }

    @Override
    public List<String> modifyTable(SqliteCompareTableInfo sqliteCompareTableInfo) {
        String rebuildTableSql;
        ArrayList<String> sqlList = new ArrayList<String>();
        List<String> deleteIndexList = sqliteCompareTableInfo.getDeleteIndexList();
        if (!deleteIndexList.isEmpty()) {
            for (String deleteIndexName : deleteIndexList) {
                sqlList.add(String.format("drop index if exists \"%s\";", deleteIndexName));
            }
        }
        if (StringUtils.hasText(rebuildTableSql = sqliteCompareTableInfo.getRebuildTableSql())) {
            String orgTableName = sqliteCompareTableInfo.getName();
            String backupTableName = this.getBackupTableName(orgTableName);
            sqlList.add(String.format("ALTER TABLE \"%s\" RENAME TO \"%s\";", orgTableName, backupTableName));
            sqlList.add(rebuildTableSql);
            sqlList.add(String.format("INSERT INTO \"%s\" SELECT * FROM \"%s\";", orgTableName, backupTableName));
        }
        List<String> buildIndexSqlList = sqliteCompareTableInfo.getBuildIndexSqlList();
        sqlList.addAll(buildIndexSqlList);
        return sqlList;
    }

    private String getBackupTableName(String orgTableName) {
        int offset = 0;
        String name = "_{orgTableName}_old_{datetime}".replace("{orgTableName}", orgTableName).replace("{datetime}", LocalDateTime.now().format(this.dateTimeFormatter));
        StringBuilder backupName = new StringBuilder(name);
        while (true) {
            String finalBackupName;
            boolean tableNotExist;
            if (offset > 0) {
                backupName.append("_").append(offset);
            }
            if (tableNotExist = this.checkTableNotExist("", finalBackupName = backupName.toString())) {
                return backupName.toString();
            }
            ++offset;
        }
    }
}

