/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.strategy.sqlite;

import com.tangzc.autotable.core.converter.DatabaseTypeAndLength;
import com.tangzc.autotable.core.strategy.sqlite.data.SqliteDefaultTypeEnum;

public class SqliteTypeHelper {
    public static String getFullType(DatabaseTypeAndLength databaseTypeAndLength, boolean isAutoIncrement) {
        String typeAndLength = databaseTypeAndLength.getType();
        if (isAutoIncrement) {
            return typeAndLength;
        }
        Integer length = databaseTypeAndLength.getLength();
        if (length != null && length > 0) {
            typeAndLength = typeAndLength + "(" + length;
            Integer decimalLength = databaseTypeAndLength.getDecimalLength();
            if (decimalLength != null && decimalLength > 0) {
                typeAndLength = typeAndLength + "," + decimalLength;
            }
            typeAndLength = typeAndLength + ")";
        }
        return typeAndLength;
    }

    public static boolean isText(DatabaseTypeAndLength type) {
        return SqliteDefaultTypeEnum.TEXT.getTypeName().equalsIgnoreCase(type.getType());
    }

    public static boolean isInteger(DatabaseTypeAndLength type) {
        return SqliteDefaultTypeEnum.INTEGER.getTypeName().equalsIgnoreCase(type.getType());
    }
}

