/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.strategy.sqlite.builder;

import com.tangzc.autotable.annotation.ColumnDefault;
import com.tangzc.autotable.core.builder.ColumnMetadataBuilder;
import com.tangzc.autotable.core.converter.DatabaseTypeAndLength;
import com.tangzc.autotable.core.strategy.sqlite.SqliteTypeHelper;
import com.tangzc.autotable.core.utils.StringUtils;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqliteColumnMetadataBuilder
extends ColumnMetadataBuilder {
    private static final Logger log = LoggerFactory.getLogger(SqliteColumnMetadataBuilder.class);

    public SqliteColumnMetadataBuilder() {
        super("SQLite");
    }

    @Override
    protected DatabaseTypeAndLength getTypeAndLength(String databaseDialect, Class<?> clazz, Field field) {
        DatabaseTypeAndLength typeAndLength = super.getTypeAndLength(databaseDialect, clazz, field);
        SqliteColumnMetadataBuilder.fixTypeAndLength(typeAndLength);
        return typeAndLength;
    }

    @Override
    protected String getDefaultValue(DatabaseTypeAndLength typeAndLength, ColumnDefault columnDefault) {
        String defaultValue = super.getDefaultValue(typeAndLength, columnDefault);
        if (StringUtils.hasText(defaultValue)) {
            boolean isBooleanType;
            boolean bl = isBooleanType = SqliteTypeHelper.isInteger(typeAndLength) && ("true".equalsIgnoreCase(defaultValue) || "false".equalsIgnoreCase(defaultValue));
            if (isBooleanType) {
                defaultValue = Boolean.parseBoolean(defaultValue) ? "1" : "0";
            }
            if (SqliteTypeHelper.isText(typeAndLength) && !defaultValue.isEmpty() && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = "'" + defaultValue + "'";
            }
        }
        return defaultValue;
    }

    private static void fixTypeAndLength(DatabaseTypeAndLength typeAndLength) {
        String type = typeAndLength.getType().toLowerCase();
        if (type.contains("int")) {
            type = "integer";
        }
        if (type.contains("char") || type.contains("clob") || type.contains("text")) {
            type = "text";
        }
        if (type.contains("blob")) {
            type = "blob";
        }
        if (type.contains("real") || type.contains("floa") || type.contains("doub")) {
            type = "real";
        }
        typeAndLength.setType(type);
    }
}

