/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.core.utils;

import com.tangzc.autotable.core.AutoTableGlobalConfig;
import com.tangzc.autotable.core.config.PropertyConfig;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class BeanClassUtil {
    public static Field getField(Class<?> clazz, String fieldName) {
        Class<?> superclass;
        Field field;
        while ((field = (Field)Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.getName().equals(fieldName)).findFirst().orElse(null)) == null && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            clazz = superclass;
        }
        if (field == null) {
            throw new RuntimeException(String.format("%s\u4e0a\u6ca1\u6709\u627e\u5230\u5b57\u6bb5\uff1a%s\uff08\u53cb\u60c5\u63d0\u793a\uff1a\u8bf7\u914d\u7f6ejava\u5b57\u6bb5\u540d\uff0c\u800c\u4e0d\u662f\u6570\u636e\u5e93\u5217\u540d\uff09", clazz.getName(), fieldName));
        }
        return field;
    }

    public static List<Field> listAllFieldForColumn(Class<?> beanClass) {
        PropertyConfig autoTableProperties = AutoTableGlobalConfig.getAutoTableProperties();
        PropertyConfig.SuperInsertPosition superInsertPosition = autoTableProperties.getSuperInsertPosition();
        ArrayList<Field> fieldList = new ArrayList<Field>();
        BeanClassUtil.getColumnFieldList(fieldList, beanClass, false, superInsertPosition == PropertyConfig.SuperInsertPosition.after, autoTableProperties.getStrictExtends());
        return fieldList;
    }

    private static void getColumnFieldList(List<Field> fields, Class<?> beanClass, boolean isParent, boolean parentInsertBack, boolean strictExtends) {
        Field[] declaredFields = beanClass.getDeclaredFields();
        Set fieldNames = fields.stream().map(Field::getName).collect(Collectors.toSet());
        List newFields = Arrays.stream(declaredFields).filter(field -> !fieldNames.contains(field.getName())).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isFinal(field.getModifiers())).filter(field -> !isParent || !strictExtends || Modifier.isProtected(field.getModifiers()) || Modifier.isPublic(field.getModifiers())).collect(Collectors.toList());
        if (parentInsertBack) {
            fields.addAll(newFields);
        } else {
            fields.addAll(0, newFields);
        }
        Class<?> superclass = beanClass.getSuperclass();
        if (superclass != null) {
            BeanClassUtil.getColumnFieldList(fields, superclass, true, parentInsertBack, strictExtends);
        }
    }
}

