/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.autotable.springboot.properties;

import com.tangzc.autotable.core.RunMode;
import com.tangzc.autotable.core.config.PropertyConfig;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="auto-table")
public class AutoTableProperties {
    public static final String ENABLE_KEY = "auto-table.enable";
    private Boolean showBanner = true;
    private Boolean enable = true;
    private RunMode mode = RunMode.update;
    private String[] modelPackage;
    private String indexPrefix = "auto_idx_";
    private Boolean autoDropColumn = false;
    private Boolean autoDropIndex = true;
    private Boolean strictExtends = true;
    private SuperInsertPosition superInsertPosition = SuperInsertPosition.after;
    private Mysql mysql = new Mysql();
    private RecordSqlProperties recordSql = new RecordSqlProperties();

    public PropertyConfig toConfig() {
        PropertyConfig propertyConfig = new PropertyConfig();
        propertyConfig.setShowBanner(this.showBanner);
        propertyConfig.setEnable(this.enable);
        propertyConfig.setMode(this.mode);
        propertyConfig.setModelPackage(this.modelPackage);
        propertyConfig.setIndexPrefix(this.indexPrefix);
        propertyConfig.setAutoDropColumn(this.autoDropColumn);
        propertyConfig.setAutoDropIndex(this.autoDropIndex);
        propertyConfig.setStrictExtends(this.strictExtends);
        PropertyConfig.SuperInsertPosition superInsertPosition = PropertyConfig.SuperInsertPosition.valueOf((String)this.superInsertPosition.name());
        propertyConfig.setSuperInsertPosition(superInsertPosition);
        PropertyConfig.MysqlConfig mysqlConfig = new PropertyConfig.MysqlConfig();
        mysqlConfig.setTableDefaultCharset(this.mysql.getTableDefaultCharset());
        mysqlConfig.setTableDefaultCharset(this.mysql.getTableDefaultCharset());
        mysqlConfig.setTableDefaultCharset(this.mysql.getTableDefaultCharset());
        mysqlConfig.setTableDefaultCharset(this.mysql.getTableDefaultCharset());
        propertyConfig.setMysql(mysqlConfig);
        PropertyConfig.RecordSqlProperties recordSqlProperties = new PropertyConfig.RecordSqlProperties();
        recordSqlProperties.setEnable(this.recordSql.enable);
        recordSqlProperties.setTableName(this.recordSql.tableName);
        recordSqlProperties.setFolderPath(this.recordSql.folderPath);
        recordSqlProperties.setRecordType(PropertyConfig.RecordSqlProperties.TypeEnum.valueOf((String)this.recordSql.recordType.name()));
        recordSqlProperties.setVersion(this.recordSql.version);
        propertyConfig.setRecordSql(recordSqlProperties);
        return propertyConfig;
    }

    public Boolean getShowBanner() {
        return this.showBanner;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public RunMode getMode() {
        return this.mode;
    }

    public String[] getModelPackage() {
        return this.modelPackage;
    }

    public String getIndexPrefix() {
        return this.indexPrefix;
    }

    public Boolean getAutoDropColumn() {
        return this.autoDropColumn;
    }

    public Boolean getAutoDropIndex() {
        return this.autoDropIndex;
    }

    public Boolean getStrictExtends() {
        return this.strictExtends;
    }

    public SuperInsertPosition getSuperInsertPosition() {
        return this.superInsertPosition;
    }

    public Mysql getMysql() {
        return this.mysql;
    }

    public RecordSqlProperties getRecordSql() {
        return this.recordSql;
    }

    public void setShowBanner(Boolean showBanner) {
        this.showBanner = showBanner;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public void setMode(RunMode mode) {
        this.mode = mode;
    }

    public void setModelPackage(String[] modelPackage) {
        this.modelPackage = modelPackage;
    }

    public void setIndexPrefix(String indexPrefix) {
        this.indexPrefix = indexPrefix;
    }

    public void setAutoDropColumn(Boolean autoDropColumn) {
        this.autoDropColumn = autoDropColumn;
    }

    public void setAutoDropIndex(Boolean autoDropIndex) {
        this.autoDropIndex = autoDropIndex;
    }

    public void setStrictExtends(Boolean strictExtends) {
        this.strictExtends = strictExtends;
    }

    public void setSuperInsertPosition(SuperInsertPosition superInsertPosition) {
        this.superInsertPosition = superInsertPosition;
    }

    public void setMysql(Mysql mysql) {
        this.mysql = mysql;
    }

    public void setRecordSql(RecordSqlProperties recordSql) {
        this.recordSql = recordSql;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoTableProperties)) {
            return false;
        }
        AutoTableProperties other = (AutoTableProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$showBanner = this.getShowBanner();
        Boolean other$showBanner = other.getShowBanner();
        if (this$showBanner == null ? other$showBanner != null : !((Object)this$showBanner).equals(other$showBanner)) {
            return false;
        }
        Boolean this$enable = this.getEnable();
        Boolean other$enable = other.getEnable();
        if (this$enable == null ? other$enable != null : !((Object)this$enable).equals(other$enable)) {
            return false;
        }
        Boolean this$autoDropColumn = this.getAutoDropColumn();
        Boolean other$autoDropColumn = other.getAutoDropColumn();
        if (this$autoDropColumn == null ? other$autoDropColumn != null : !((Object)this$autoDropColumn).equals(other$autoDropColumn)) {
            return false;
        }
        Boolean this$autoDropIndex = this.getAutoDropIndex();
        Boolean other$autoDropIndex = other.getAutoDropIndex();
        if (this$autoDropIndex == null ? other$autoDropIndex != null : !((Object)this$autoDropIndex).equals(other$autoDropIndex)) {
            return false;
        }
        Boolean this$strictExtends = this.getStrictExtends();
        Boolean other$strictExtends = other.getStrictExtends();
        if (this$strictExtends == null ? other$strictExtends != null : !((Object)this$strictExtends).equals(other$strictExtends)) {
            return false;
        }
        RunMode this$mode = this.getMode();
        RunMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getModelPackage(), other.getModelPackage())) {
            return false;
        }
        String this$indexPrefix = this.getIndexPrefix();
        String other$indexPrefix = other.getIndexPrefix();
        if (this$indexPrefix == null ? other$indexPrefix != null : !this$indexPrefix.equals(other$indexPrefix)) {
            return false;
        }
        SuperInsertPosition this$superInsertPosition = this.getSuperInsertPosition();
        SuperInsertPosition other$superInsertPosition = other.getSuperInsertPosition();
        if (this$superInsertPosition == null ? other$superInsertPosition != null : !((Object)((Object)this$superInsertPosition)).equals((Object)other$superInsertPosition)) {
            return false;
        }
        Mysql this$mysql = this.getMysql();
        Mysql other$mysql = other.getMysql();
        if (this$mysql == null ? other$mysql != null : !((Object)this$mysql).equals(other$mysql)) {
            return false;
        }
        RecordSqlProperties this$recordSql = this.getRecordSql();
        RecordSqlProperties other$recordSql = other.getRecordSql();
        return !(this$recordSql == null ? other$recordSql != null : !((Object)this$recordSql).equals(other$recordSql));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoTableProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $showBanner = this.getShowBanner();
        result = result * 59 + ($showBanner == null ? 43 : ((Object)$showBanner).hashCode());
        Boolean $enable = this.getEnable();
        result = result * 59 + ($enable == null ? 43 : ((Object)$enable).hashCode());
        Boolean $autoDropColumn = this.getAutoDropColumn();
        result = result * 59 + ($autoDropColumn == null ? 43 : ((Object)$autoDropColumn).hashCode());
        Boolean $autoDropIndex = this.getAutoDropIndex();
        result = result * 59 + ($autoDropIndex == null ? 43 : ((Object)$autoDropIndex).hashCode());
        Boolean $strictExtends = this.getStrictExtends();
        result = result * 59 + ($strictExtends == null ? 43 : ((Object)$strictExtends).hashCode());
        RunMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getModelPackage());
        String $indexPrefix = this.getIndexPrefix();
        result = result * 59 + ($indexPrefix == null ? 43 : $indexPrefix.hashCode());
        SuperInsertPosition $superInsertPosition = this.getSuperInsertPosition();
        result = result * 59 + ($superInsertPosition == null ? 43 : ((Object)((Object)$superInsertPosition)).hashCode());
        Mysql $mysql = this.getMysql();
        result = result * 59 + ($mysql == null ? 43 : ((Object)$mysql).hashCode());
        RecordSqlProperties $recordSql = this.getRecordSql();
        result = result * 59 + ($recordSql == null ? 43 : ((Object)$recordSql).hashCode());
        return result;
    }

    public String toString() {
        return "AutoTableProperties(showBanner=" + this.getShowBanner() + ", enable=" + this.getEnable() + ", mode=" + this.getMode() + ", modelPackage=" + Arrays.deepToString(this.getModelPackage()) + ", indexPrefix=" + this.getIndexPrefix() + ", autoDropColumn=" + this.getAutoDropColumn() + ", autoDropIndex=" + this.getAutoDropIndex() + ", strictExtends=" + this.getStrictExtends() + ", superInsertPosition=" + (Object)((Object)this.getSuperInsertPosition()) + ", mysql=" + this.getMysql() + ", recordSql=" + this.getRecordSql() + ")";
    }

    public static enum SuperInsertPosition {
        after,
        before;

    }

    public static class Mysql {
        private String tableDefaultCharset;
        private String tableDefaultCollation;
        private String columnDefaultCharset;
        private String columnDefaultCollation;

        public String getTableDefaultCharset() {
            return this.tableDefaultCharset;
        }

        public String getTableDefaultCollation() {
            return this.tableDefaultCollation;
        }

        public String getColumnDefaultCharset() {
            return this.columnDefaultCharset;
        }

        public String getColumnDefaultCollation() {
            return this.columnDefaultCollation;
        }

        public void setTableDefaultCharset(String tableDefaultCharset) {
            this.tableDefaultCharset = tableDefaultCharset;
        }

        public void setTableDefaultCollation(String tableDefaultCollation) {
            this.tableDefaultCollation = tableDefaultCollation;
        }

        public void setColumnDefaultCharset(String columnDefaultCharset) {
            this.columnDefaultCharset = columnDefaultCharset;
        }

        public void setColumnDefaultCollation(String columnDefaultCollation) {
            this.columnDefaultCollation = columnDefaultCollation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mysql)) {
                return false;
            }
            Mysql other = (Mysql)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$tableDefaultCharset = this.getTableDefaultCharset();
            String other$tableDefaultCharset = other.getTableDefaultCharset();
            if (this$tableDefaultCharset == null ? other$tableDefaultCharset != null : !this$tableDefaultCharset.equals(other$tableDefaultCharset)) {
                return false;
            }
            String this$tableDefaultCollation = this.getTableDefaultCollation();
            String other$tableDefaultCollation = other.getTableDefaultCollation();
            if (this$tableDefaultCollation == null ? other$tableDefaultCollation != null : !this$tableDefaultCollation.equals(other$tableDefaultCollation)) {
                return false;
            }
            String this$columnDefaultCharset = this.getColumnDefaultCharset();
            String other$columnDefaultCharset = other.getColumnDefaultCharset();
            if (this$columnDefaultCharset == null ? other$columnDefaultCharset != null : !this$columnDefaultCharset.equals(other$columnDefaultCharset)) {
                return false;
            }
            String this$columnDefaultCollation = this.getColumnDefaultCollation();
            String other$columnDefaultCollation = other.getColumnDefaultCollation();
            return !(this$columnDefaultCollation == null ? other$columnDefaultCollation != null : !this$columnDefaultCollation.equals(other$columnDefaultCollation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mysql;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $tableDefaultCharset = this.getTableDefaultCharset();
            result = result * 59 + ($tableDefaultCharset == null ? 43 : $tableDefaultCharset.hashCode());
            String $tableDefaultCollation = this.getTableDefaultCollation();
            result = result * 59 + ($tableDefaultCollation == null ? 43 : $tableDefaultCollation.hashCode());
            String $columnDefaultCharset = this.getColumnDefaultCharset();
            result = result * 59 + ($columnDefaultCharset == null ? 43 : $columnDefaultCharset.hashCode());
            String $columnDefaultCollation = this.getColumnDefaultCollation();
            result = result * 59 + ($columnDefaultCollation == null ? 43 : $columnDefaultCollation.hashCode());
            return result;
        }

        public String toString() {
            return "AutoTableProperties.Mysql(tableDefaultCharset=" + this.getTableDefaultCharset() + ", tableDefaultCollation=" + this.getTableDefaultCollation() + ", columnDefaultCharset=" + this.getColumnDefaultCharset() + ", columnDefaultCollation=" + this.getColumnDefaultCollation() + ")";
        }
    }

    public static class RecordSqlProperties {
        private boolean enable = false;
        private TypeEnum recordType = TypeEnum.db;
        private String version;
        private String tableName;
        private String folderPath;

        public boolean isEnable() {
            return this.enable;
        }

        public TypeEnum getRecordType() {
            return this.recordType;
        }

        public String getVersion() {
            return this.version;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getFolderPath() {
            return this.folderPath;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setRecordType(TypeEnum recordType) {
            this.recordType = recordType;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setFolderPath(String folderPath) {
            this.folderPath = folderPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RecordSqlProperties)) {
                return false;
            }
            RecordSqlProperties other = (RecordSqlProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnable() != other.isEnable()) {
                return false;
            }
            TypeEnum this$recordType = this.getRecordType();
            TypeEnum other$recordType = other.getRecordType();
            if (this$recordType == null ? other$recordType != null : !((Object)((Object)this$recordType)).equals((Object)other$recordType)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$folderPath = this.getFolderPath();
            String other$folderPath = other.getFolderPath();
            return !(this$folderPath == null ? other$folderPath != null : !this$folderPath.equals(other$folderPath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RecordSqlProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnable() ? 79 : 97);
            TypeEnum $recordType = this.getRecordType();
            result = result * 59 + ($recordType == null ? 43 : ((Object)((Object)$recordType)).hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $folderPath = this.getFolderPath();
            result = result * 59 + ($folderPath == null ? 43 : $folderPath.hashCode());
            return result;
        }

        public String toString() {
            return "AutoTableProperties.RecordSqlProperties(enable=" + this.isEnable() + ", recordType=" + (Object)((Object)this.getRecordType()) + ", version=" + this.getVersion() + ", tableName=" + this.getTableName() + ", folderPath=" + this.getFolderPath() + ")";
        }

        public static enum TypeEnum {
            db,
            file,
            custom;

        }
    }
}

