/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mybatisflex.core;

import com.mybatisflex.annotation.InsertListener;
import com.mybatisflex.annotation.UpdateListener;
import com.tangzc.mybatisflex.annotation.DefaultValue;
import com.tangzc.mybatisflex.annotation.FieldFill;
import com.tangzc.mybatisflex.annotation.FillData;
import com.tangzc.mybatisflex.annotation.FillTime;
import com.tangzc.mybatisflex.annotation.handler.AutoFillHandler;
import com.tangzc.mybatisflex.core.FieldTypeHandler;
import com.tangzc.mybatisflex.util.SpringContextUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.cglib.core.ReflectUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ReflectionUtils;

public class EntityWriteListener
implements InsertListener,
UpdateListener {
    private static final Logger log = LoggerFactory.getLogger(EntityWriteListener.class);
    public Map<Class<?>, Class<?>> baseTypeClassMap = new HashMap();
    private static final Map<Class<?>, List<Field>> FIELD_LIST_CATCH_MAP = new HashMap();

    public EntityWriteListener() {
        this.baseTypeClassMap.put(Byte.class, Byte.TYPE);
        this.baseTypeClassMap.put(Short.class, Short.TYPE);
        this.baseTypeClassMap.put(Integer.class, Integer.TYPE);
        this.baseTypeClassMap.put(Long.class, Long.TYPE);
        this.baseTypeClassMap.put(Double.class, Double.TYPE);
        this.baseTypeClassMap.put(Float.class, Float.TYPE);
        this.baseTypeClassMap.put(Character.class, Character.TYPE);
        this.baseTypeClassMap.put(Boolean.class, Boolean.TYPE);
    }

    public void onInsert(Object entity) {
        Class<?> clazz = entity.getClass();
        List<Field> fieldList = EntityWriteListener.getFieldList(clazz);
        if (!fieldList.isEmpty()) {
            this.fill(FieldFill.INSERT, entity, clazz, fieldList);
        }
    }

    public void onUpdate(Object entity) {
        Class<?> clazz = entity.getClass();
        List<Field> fieldList = EntityWriteListener.getFieldList(clazz);
        if (!fieldList.isEmpty()) {
            this.fill(FieldFill.UPDATE, entity, clazz, fieldList);
        }
    }

    public void fill(FieldFill fill, Object object, Class<?> clazz, List<Field> fieldList) {
        Now now = new Now();
        fieldList.forEach(field -> {
            this.setDefaultVale(fill, object, clazz, (Field)field);
            this.setOptionDate(object, clazz, (Field)field, now);
            this.setOptionUser(object, clazz, (Field)field);
        });
    }

    private void setDefaultVale(FieldFill fill, Object object, Class<?> clazz, Field field) {
        DefaultValue defaultValue = (DefaultValue)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, DefaultValue.class);
        if (defaultValue != null && (defaultValue.fill() == FieldFill.INSERT_UPDATE || defaultValue.fill() == fill)) {
            boolean canSet;
            PropertyDescriptor propertyDescriptor = EntityWriteListener.getPropertyDescriptor(clazz, field);
            Method readMethod = propertyDescriptor.getReadMethod();
            boolean bl = canSet = ReflectionUtils.invokeMethod((Method)readMethod, (Object)object) == null;
            if (canSet) {
                Object newVal = this.convert(field, defaultValue);
                Method writeMethod = propertyDescriptor.getWriteMethod();
                writeMethod.setAccessible(true);
                ReflectionUtils.invokeMethod((Method)writeMethod, (Object)object, (Object[])new Object[]{newVal});
            }
        }
    }

    private void setOptionUser(Object object, Class<?> clazz, Field field) {
        FillData fillData = (FillData)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, FillData.class);
        if (fillData != null) {
            boolean canSet;
            PropertyDescriptor propertyDescriptor = EntityWriteListener.getPropertyDescriptor(clazz, field);
            boolean bl = canSet = fillData.override() || ReflectionUtils.invokeMethod((Method)propertyDescriptor.getReadMethod(), (Object)object) == null;
            if (canSet) {
                Object userInfo = null;
                AutoFillHandler instance = this.getAutoFillHandler(fillData.value());
                if (instance != null) {
                    userInfo = instance.getVal(object, clazz, field);
                }
                if (userInfo != null) {
                    if (!this.checkTypeConsistency(userInfo.getClass(), field.getType())) {
                        String errorMsg = clazz.getName() + "\u4e2d\u7684\u5b57\u6bb5" + field.getName() + "\u7684\u7c7b\u578b\uff08" + field.getType() + "\uff09\u4e0e" + instance.getClass() + "\u8fd4\u56de\u503c\u7684\u7c7b\u578b\uff08" + userInfo.getClass() + "\uff09\u4e0d\u4e00\u81f4";
                        throw new RuntimeException(errorMsg);
                    }
                    ReflectionUtils.invokeMethod((Method)propertyDescriptor.getWriteMethod(), (Object)object, (Object[])new Object[]{userInfo});
                }
            }
        }
    }

    private static List<Field> getFieldList(Class<?> clazz) {
        return FIELD_LIST_CATCH_MAP.computeIfAbsent(clazz, $ -> {
            Field[] declaredFields = clazz.getDeclaredFields();
            ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(declaredFields));
            for (Class superClass = clazz.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                declaredFields = superClass.getDeclaredFields();
                fields.addAll(Arrays.asList(declaredFields));
            }
            return fields.stream().filter(field -> AnnotatedElementUtils.hasMetaAnnotationTypes((AnnotatedElement)field, FillTime.class) || AnnotatedElementUtils.hasMetaAnnotationTypes((AnnotatedElement)field, FillData.class) || AnnotatedElementUtils.hasMetaAnnotationTypes((AnnotatedElement)field, DefaultValue.class)).collect(Collectors.toList());
        });
    }

    private boolean checkTypeConsistency(Class<?> aClass, Class<?> bClass) {
        return aClass == bClass || this.baseTypeClassMap.get(aClass) == bClass || this.baseTypeClassMap.get(bClass) == aClass;
    }

    private AutoFillHandler getAutoFillHandler(Class<? extends AutoFillHandler> autoFillHandler) {
        try {
            return SpringContextUtil.getBeanOfType(autoFillHandler);
        }
        catch (NoUniqueBeanDefinitionException ignore) {
            throw new RuntimeException("\u53d1\u73b0\u4e86\u591a\u4e2a" + autoFillHandler.getName() + "\u7684\u5b9e\u73b0\uff0c\u8bf7\u4fdd\u6301spring\u4e2d\u53ea\u6709\u4e00\u4e2a\u5b9e\u4f8b\u3002");
        }
        catch (NoSuchBeanDefinitionException ignore) {
            if (autoFillHandler.isInterface()) {
                log.warn("\u6ca1\u6709\u627e\u5230{}\u7684\u5b9e\u73b0\uff0c\u64cd\u4f5c\u4eba\u4fe1\u606f\u65e0\u6cd5\u81ea\u52a8\u586b\u5145\u3002", (Object)autoFillHandler.getName());
            } else {
                log.warn("{}\u9700\u8981\u6ce8\u518c\u5230spring\uff0c\u4e0d\u7136\u64cd\u4f5c\u4eba\u4fe1\u606f\u65e0\u6cd5\u81ea\u52a8\u586b\u5145\u3002", (Object)autoFillHandler.getName());
            }
            return null;
        }
    }

    private void setOptionDate(Object object, Class<?> clazz, Field field, Now now) {
        FillTime fillTime = (FillTime)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, FillTime.class);
        if (fillTime != null) {
            boolean canSet;
            PropertyDescriptor propertyDescriptor = EntityWriteListener.getPropertyDescriptor(clazz, field);
            boolean bl = canSet = fillTime.override() || ReflectionUtils.invokeMethod((Method)propertyDescriptor.getReadMethod(), (Object)object) == null;
            if (canSet) {
                Class<?> type = this.getDateType(clazz, field);
                Object nowDate = Optional.ofNullable(now.now(type, fillTime.format())).orElseThrow(() -> new RuntimeException("\u7c7b\uff1a" + clazz.toString() + "\u7684\u5b57\u6bb5\uff1a" + field.getName() + "\u7684\u7c7b\u578b\u4e0d\u652f\u6301\u3002\u4ec5\u652f\u6301String\u3001Long\u3001long\u3001Date\u3001LocalDate\u3001LocalDateTime"));
                ReflectionUtils.invokeMethod((Method)propertyDescriptor.getWriteMethod(), (Object)object, (Object[])new Object[]{nowDate});
            }
        }
    }

    private Class<?> getDateType(Class<?> clazz, Field field) {
        Class<?> type = field.getType();
        try {
            FieldTypeHandler fieldTypeHandler = SpringContextUtil.getBeanOfType(FieldTypeHandler.class);
            type = fieldTypeHandler.getDateType(clazz, field);
        }
        catch (BeansException beansException) {
            // empty catch block
        }
        return type;
    }

    private static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, Field field) {
        PropertyDescriptor[] beanProperties = ReflectUtils.getBeanProperties(clazz);
        return Arrays.stream(beanProperties).filter(bp -> bp.getName().equals(field.getName())).findFirst().orElseThrow(() -> new RuntimeException(clazz.getName() + "\u4e0b\u6ca1\u6709\u627e\u5230\u5b57\u6bb5" + field.getName() + "\u7684getter\u3001setter"));
    }

    private Object convert(Field field, DefaultValue defaultValue) {
        String value = defaultValue.value();
        final String format = defaultValue.format();
        Class<?> type = field.getType();
        HashMap convertFuncMap = new HashMap<Class<?>, Function<String, Object>>(16){
            {
                super(initialCapacity);
                this.put(String.class, value -> value);
                this.put(Long.class, Long::parseLong);
                this.put(Long.TYPE, Long::parseLong);
                this.put(Integer.class, Integer::parseInt);
                this.put(Integer.TYPE, Integer::parseInt);
                this.put(Boolean.class, Boolean::parseBoolean);
                this.put(Boolean.TYPE, Boolean::parseBoolean);
                this.put(Double.class, Double::parseDouble);
                this.put(Double.TYPE, Double::parseDouble);
                this.put(Float.class, Float::parseFloat);
                this.put(Float.TYPE, Float::parseFloat);
                this.put(BigDecimal.class, BigDecimal::new);
                this.put(Date.class, value -> {
                    try {
                        return new SimpleDateFormat(format).parse((String)value);
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("\u65e5\u671f\u683c\u5f0f" + format + "\u4e0e\u503c" + value + "\u4e0d\u5339\u914d\uff01");
                    }
                });
                this.put(LocalDate.class, value -> {
                    try {
                        return LocalDate.parse(value, DateTimeFormatter.ofPattern(format));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u65e5\u671f\u683c\u5f0f" + format + "\u4e0e\u503c" + value + "\u4e0d\u5339\u914d\uff01");
                    }
                });
                this.put(LocalDateTime.class, value -> {
                    try {
                        return LocalDateTime.parse(value, DateTimeFormatter.ofPattern(format));
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u65e5\u671f\u683c\u5f0f" + format + "\u4e0e\u503c" + value + "\u4e0d\u5339\u914d\uff01");
                    }
                });
            }
        };
        Function<String, Object> convertFunc = convertFuncMap.getOrDefault(type, val -> {
            if (type.isEnum()) {
                T[] enumConstants = type.getEnumConstants();
                if (enumConstants.length > 0) {
                    for (Object enumConstant : enumConstants) {
                        if (!Objects.equals(val, enumConstant.toString())) continue;
                        return enumConstant;
                    }
                }
                throw new RuntimeException("\u9ed8\u8ba4\u503c" + val + "\u4e0e\u679a\u4e3e" + type.getName() + "\u4e0d\u5339\u914d\uff01");
            }
            return val;
        });
        return convertFunc.apply(value);
    }

    private static class Now {
        private final LocalDateTime localDateTime = LocalDateTime.now();
        private final LocalDate localDate = this.localDateTime.toLocalDate();
        private final Date date = Date.from(this.localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        private final Long timestamp = this.date.getTime();

        private Now() {
        }

        public Object now(Class<?> type, String format) {
            if (type == String.class) {
                return this.localDateTime.format(DateTimeFormatter.ofPattern(format));
            }
            if (type == Long.TYPE || type == Long.class) {
                return this.timestamp;
            }
            if (type == Date.class) {
                return this.date;
            }
            if (type == LocalDate.class) {
                return this.localDate;
            }
            if (type == LocalDateTime.class) {
                return this.localDateTime;
            }
            return null;
        }
    }
}

