/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable;

import com.tangzc.mpe.autotable.EnableAutoTable;
import com.tangzc.mpe.autotable.utils.ClassScanner;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class ProfileCondition
implements Condition {
    private static final Logger log = LoggerFactory.getLogger(ProfileCondition.class);

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        boolean isDefault;
        Class applicationClass = SpringContextUtil.getApplicationClass();
        EnableAutoTable enableAutoTable = applicationClass.getAnnotation(EnableAutoTable.class);
        if (enableAutoTable == null && (applicationClass = (Class)ClassScanner.scan(new String[]{SpringContextUtil.getBootPackage()}, EnableAutoTable.class).stream().findFirst().orElse(null)) != null) {
            enableAutoTable = applicationClass.getAnnotation(EnableAutoTable.class);
        }
        if (enableAutoTable == null) {
            log.error("\u672a\u627e\u5230EnableAutoTable\u58f0\u660e\uff0c\u65e0\u6cd5\u81ea\u52a8\u5efa\u8868");
            return false;
        }
        Set includeProfiles = Arrays.stream(enableAutoTable.activeProfile()).collect(Collectors.toSet());
        String[] properties = (String[])context.getEnvironment().getProperty(enableAutoTable.profileProperty(), String[].class);
        boolean bl = isDefault = includeProfiles.size() == 1 && includeProfiles.contains("");
        if (isDefault) {
            return true;
        }
        if (properties != null && properties.length > 0) {
            Set propertySet = Arrays.stream(properties).collect(Collectors.toSet());
            return includeProfiles.stream().anyMatch(propertySet::contains);
        }
        return false;
    }
}

