/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable;

import com.tangzc.mpe.autotable.ProfileCondition;
import com.tangzc.mpe.autotable.annotation.Table;
import com.tangzc.mpe.autotable.constants.RunMode;
import com.tangzc.mpe.autotable.dynamicds.IDatasourceHandler;
import com.tangzc.mpe.autotable.properties.AutoTableProperties;
import com.tangzc.mpe.autotable.utils.ClassScanner;
import com.tangzc.mpe.magic.TableColumnNameUtil;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;

@Conditional(value={ProfileCondition.class})
public class StartUp {
    private static final Logger log = LoggerFactory.getLogger(StartUp.class);
    @Resource
    private AutoTableProperties autoTableProperties;
    @Resource
    private IDatasourceHandler dynamicDatasourceHandler;

    @PostConstruct
    public void startHandler() {
        if (this.autoTableProperties.getMode() == RunMode.none) {
            return;
        }
        String[] packs = this.getModelPackage();
        Set<Class<?>> classes = ClassScanner.scan(packs, Table.class);
        Map<String, Set<Class<?>>> needHandleTableMap = this.filterTable(classes);
        this.dynamicDatasourceHandler.initTable(needHandleTableMap);
    }

    private String[] getModelPackage() {
        String[] packs = this.autoTableProperties.getModelPackage();
        if (packs == null) {
            packs = new String[]{StartUp.getBootPackage()};
        }
        return packs;
    }

    private Map<String, Set<Class<?>>> filterTable(Set<Class<?>> classes) {
        Map<String, List<Class>> tableClassMap = classes.stream().collect(Collectors.groupingBy(TableColumnNameUtil::getTableName));
        HashMap needHandleTableMap = new HashMap(tableClassMap.size());
        tableClassMap.forEach((tableName, sameClasses) -> {
            Class primaryClass;
            if (sameClasses.size() > 1) {
                List<Class> primaryClasses = sameClasses.stream().filter(StartUp::isPrimary).toList();
                if (primaryClasses.isEmpty()) {
                    throw new RuntimeException("\u8868\u540d[" + tableName + "]\u51fa\u73b0\u91cd\u590d\uff0c\u5fc5\u987b\u4e3a\u5176\u4e2d\u4e00\u4e2a@Table\u6307\u5b9aprimary\uff01");
                }
                if (primaryClasses.size() > 1) {
                    throw new RuntimeException("\u8868\u540d[" + tableName + "]\u51fa\u73b0\u91cd\u590d\uff0c\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a@Table\u7684primary\u4e3atrue\uff01");
                }
                primaryClass = primaryClasses.get(0);
            } else {
                primaryClass = (Class)sameClasses.get(0);
            }
            Table tableAnno = (Table)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)primaryClass, Table.class);
            assert (tableAnno != null);
            needHandleTableMap.computeIfAbsent(tableAnno.dsName(), k -> new HashSet()).add(primaryClass);
        });
        return needHandleTableMap;
    }

    private static boolean isPrimary(Class<?> clazz) {
        Table annotation = (Table)AnnotatedElementUtils.findMergedAnnotation(clazz, Table.class);
        return annotation != null && annotation.primary();
    }

    private static String getBootPackage() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            return ClassUtils.getPackageName((String)stackTraceElement.getClassName());
        }
        throw new RuntimeException("\u672a\u627e\u5230\u4e3b\u9ed8\u8ba4\u5305");
    }
}

