/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.dynamicds;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.tangzc.mpe.autotable.constants.DatabaseDialect;
import com.tangzc.mpe.autotable.strategy.IStrategy;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface IDatasourceHandler {
    public static final Logger log = LoggerFactory.getLogger(IDatasourceHandler.class);

    default public void start(Set<Class<?>> beanClasses) {
        DatabaseDialect databaseDialect = this.getDatabaseDialect();
        if (databaseDialect != null) {
            log.info("\u5f53\u524d\u6570\u636e\u5e93\u65b9\u8a00\uff08" + databaseDialect + "\uff09");
            IStrategy<?, ?> databaseStrategy = this.getDatabaseStrategy(databaseDialect);
            if (databaseStrategy != null) {
                databaseStrategy.analyseClasses(beanClasses);
                return;
            }
        }
        log.warn("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e\u5e93\uff08" + databaseDialect + "\uff09\u65b9\u8a00\u7b56\u7565\uff0c\u65e0\u6cd5\u6267\u884c\u81ea\u52a8\u5efa\u8868");
    }

    default public DatabaseDialect getDatabaseDialect() {
        String driverName;
        String dynamicDsClassName = "com.baomidou.dynamic.datasource.DynamicRoutingDataSource";
        DataSource dataSource = (DataSource)SpringContextUtil.getBeanOfType(DataSource.class);
        if (dynamicDsClassName.equals(dataSource.getClass().getName())) {
            log.info("\u591a\u6570\u636e\u6e90\u6a21\u5f0f\uff1a" + DynamicRoutingDataSource.class.getName());
            dataSource = ((DynamicRoutingDataSource)dataSource).getDataSource(DynamicDataSourceContextHolder.peek());
            DataSource realDataSource = ((ItemDataSource)dataSource).getRealDataSource();
            try {
                driverName = realDataSource.getConnection().getMetaData().getDriverName();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            driverName = dataSource.getConnection().getMetaData().getDriverName();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return DatabaseDialect.parseFromDriverName(driverName);
    }

    default public IStrategy<?, ?> getDatabaseStrategy(DatabaseDialect databaseDialect) {
        return SpringContextUtil.getBeansOfTypeList(IStrategy.class).stream().filter(strategy -> strategy.dbDialect() == databaseDialect).findFirst().orElse(null);
    }

    public void initTable(Map<String, Set<Class<?>>> var1);
}

