/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy;

import com.tangzc.mpe.autotable.constants.DatabaseDialect;
import com.tangzc.mpe.autotable.constants.RunMode;
import com.tangzc.mpe.autotable.properties.AutoTableProperties;
import com.tangzc.mpe.autotable.strategy.CompareTableInfo;
import com.tangzc.mpe.autotable.strategy.TableMetadata;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public interface IStrategy<TABLE_META extends TableMetadata, COMPARE_TABLE_INFO extends CompareTableInfo> {
    public static final Logger log = LoggerFactory.getLogger(IStrategy.class);

    public DatabaseDialect dbDialect();

    @Transactional(rollbackFor={Exception.class})
    default public void analyseClasses(Set<Class<?>> beanClasses) {
        AutoTableProperties autoTableProperties = (AutoTableProperties)SpringContextUtil.getBeanOfType(AutoTableProperties.class);
        if (autoTableProperties.getMode() == RunMode.validate) {
            this.validateMode(beanClasses);
        } else {
            this.createOrUpdateMode(beanClasses, autoTableProperties.getMode());
        }
    }

    default public void createOrUpdateMode(Set<Class<?>> beanClasses, RunMode runMode) {
        for (Class<?> beanClass : beanClasses) {
            boolean tableIsExist;
            TABLE_META tableMetadata = this.analyseClass(beanClass);
            if (tableMetadata == null) continue;
            String tableName = tableMetadata.getTableName();
            if (runMode == RunMode.create) {
                log.info("create\u6a21\u5f0f\uff0c\u5220\u9664\u8868\uff1a{}", (Object)tableName);
                this.dropTable(tableName);
            }
            if (tableIsExist = this.checkTableExist(tableName)) {
                COMPARE_TABLE_INFO compareTableInfo = this.compareTable(tableMetadata);
                if (!compareTableInfo.needModify()) continue;
                this.modifyTable(compareTableInfo);
                continue;
            }
            log.info("\u521b\u5efa\u8868\uff1a{}", (Object)tableName);
            this.createTable(tableMetadata);
        }
    }

    default public void validateMode(Set<Class<?>> beanClasses) {
        ArrayList<CallSite> validateResult = new ArrayList<CallSite>();
        for (Class<?> beanClass : beanClasses) {
            TABLE_META tableMetadata = this.analyseClass(beanClass);
            if (tableMetadata == null) continue;
            String tableName = tableMetadata.getTableName();
            boolean tableIsExist = this.checkTableExist(tableName);
            if (tableIsExist) {
                COMPARE_TABLE_INFO compareTableInfo = this.compareTable(tableMetadata);
                if (!compareTableInfo.needModify()) continue;
                validateResult.add((CallSite)((Object)("\u8868" + tableName + "\u7ed3\u6784\u4e0d\u4e00\u81f4")));
                continue;
            }
            validateResult.add((CallSite)((Object)("\u8868" + tableName + "\u4e0d\u5b58\u5728")));
        }
        if (!validateResult.isEmpty()) {
            throw new RuntimeException("\u542f\u52a8\u5931\u8d25\uff0c" + this.dbDialect() + "\u6570\u636e\u5e93\u4e0e\u5b9e\u4f53\u6a21\u578b\u4e0d\u5bf9\u5e94\uff1a\n" + String.join((CharSequence)"\n", validateResult));
        }
    }

    public void dropTable(String var1);

    public boolean checkTableExist(String var1);

    public TABLE_META analyseClass(Class<?> var1);

    public void createTable(TABLE_META var1);

    public COMPARE_TABLE_INFO compareTable(TABLE_META var1);

    public void modifyTable(COMPARE_TABLE_INFO var1);
}

