/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.mysql;

import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlColumnMetadata;
import com.tangzc.mpe.autotable.strategy.mysql.data.dbdata.InformationSchemaColumn;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ColumnPositionHelper {
    public static void generateChangePosition(List<InformationSchemaColumn> dbColumns, List<MysqlColumnMetadata> expectPositions) {
        List realPositions = dbColumns.stream().map(col -> new InformationSchemaColumnPosition(col.getColumnName(), col.getOrdinalPosition())).collect(Collectors.toList());
        Set entityColumnsSet = expectPositions.stream().map(MysqlColumnMetadata::getName).collect(Collectors.toSet());
        ArrayList<InformationSchemaColumnPosition> removeColumns = new ArrayList<InformationSchemaColumnPosition>(realPositions.size());
        for (Object realPosition : realPositions) {
            if (!entityColumnsSet.contains(((InformationSchemaColumnPosition)realPosition).getColumnName())) {
                removeColumns.add((InformationSchemaColumnPosition)realPosition);
                continue;
            }
            if (removeColumns.isEmpty()) continue;
            ((InformationSchemaColumnPosition)realPosition).setOrdinalPosition(((InformationSchemaColumnPosition)realPosition).getOrdinalPosition() - removeColumns.size());
        }
        realPositions.removeAll(removeColumns);
        Set dbColumnsSet = realPositions.stream().map(InformationSchemaColumnPosition::getColumnName).collect(Collectors.toSet());
        for (MysqlColumnMetadata expectPosition : expectPositions) {
            if (dbColumnsSet.contains(expectPosition.getName())) continue;
            realPositions.add(new InformationSchemaColumnPosition(expectPosition.getName(), realPositions.size() + 1));
        }
        Map dbColumnPositionMap = realPositions.stream().collect(Collectors.toMap(InformationSchemaColumnPosition::getColumnName, Function.identity()));
        Map columnMetadataMap = expectPositions.stream().collect(Collectors.toMap(MysqlColumnMetadata::getName, Function.identity()));
        for (int index = 0; index < expectPositions.size(); ++index) {
            String realColumnName;
            String expectColumnName = expectPositions.get(index).getName();
            if (Objects.equals(expectColumnName, realColumnName = ((InformationSchemaColumnPosition)realPositions.get(index)).getColumnName())) continue;
            Integer expectColumnNameRealPosition = ((InformationSchemaColumnPosition)dbColumnPositionMap.get(expectColumnName)).getOrdinalPosition();
            realPositions.remove(expectColumnNameRealPosition - 1);
            realPositions.add(index, new InformationSchemaColumnPosition(expectColumnName, index + 1));
            for (int i = index + 1; i < expectColumnNameRealPosition; ++i) {
                InformationSchemaColumnPosition columnPosition = (InformationSchemaColumnPosition)realPositions.get(i);
                columnPosition.setOrdinalPosition(columnPosition.getOrdinalPosition() + 1);
            }
            if (index == 0) {
                ((MysqlColumnMetadata)columnMetadataMap.get(expectColumnName)).setNewPreColumn("");
                continue;
            }
            ((MysqlColumnMetadata)columnMetadataMap.get(expectColumnName)).setNewPreColumn(((InformationSchemaColumnPosition)realPositions.get(index - 1)).getColumnName());
        }
    }

    public static class InformationSchemaColumnPosition {
        private String columnName;
        private Integer ordinalPosition;

        public String getColumnName() {
            return this.columnName;
        }

        public Integer getOrdinalPosition() {
            return this.ordinalPosition;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public void setOrdinalPosition(Integer ordinalPosition) {
            this.ordinalPosition = ordinalPosition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InformationSchemaColumnPosition)) {
                return false;
            }
            InformationSchemaColumnPosition other = (InformationSchemaColumnPosition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$ordinalPosition = this.getOrdinalPosition();
            Integer other$ordinalPosition = other.getOrdinalPosition();
            if (this$ordinalPosition == null ? other$ordinalPosition != null : !((Object)this$ordinalPosition).equals(other$ordinalPosition)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InformationSchemaColumnPosition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $ordinalPosition = this.getOrdinalPosition();
            result = result * 59 + ($ordinalPosition == null ? 43 : ((Object)$ordinalPosition).hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            return result;
        }

        public String toString() {
            return "ColumnPositionHelper.InformationSchemaColumnPosition(columnName=" + this.getColumnName() + ", ordinalPosition=" + this.getOrdinalPosition() + ")";
        }

        public InformationSchemaColumnPosition(String columnName, Integer ordinalPosition) {
            this.columnName = columnName;
            this.ordinalPosition = ordinalPosition;
        }
    }
}

