/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.mysql;

import com.google.common.base.Functions;
import com.tangzc.mpe.autotable.annotation.enums.DefaultValueEnum;
import com.tangzc.mpe.autotable.annotation.enums.IndexSortTypeEnum;
import com.tangzc.mpe.autotable.constants.DatabaseDialect;
import com.tangzc.mpe.autotable.properties.AutoTableProperties;
import com.tangzc.mpe.autotable.strategy.IStrategy;
import com.tangzc.mpe.autotable.strategy.mysql.ColumnPositionHelper;
import com.tangzc.mpe.autotable.strategy.mysql.builder.CreateTableSqlBuilder;
import com.tangzc.mpe.autotable.strategy.mysql.builder.ModifyTableSqlBuilder;
import com.tangzc.mpe.autotable.strategy.mysql.builder.TableMetadataBuilder;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlColumnMetadata;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlCompareTableInfo;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlIndexMetadata;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlTableMetadata;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlTypeAndLength;
import com.tangzc.mpe.autotable.strategy.mysql.data.dbdata.InformationSchemaColumn;
import com.tangzc.mpe.autotable.strategy.mysql.data.dbdata.InformationSchemaStatistics;
import com.tangzc.mpe.autotable.strategy.mysql.data.dbdata.InformationSchemaTable;
import com.tangzc.mpe.autotable.strategy.mysql.mapper.MysqlTablesMapper;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MysqlStrategy
implements IStrategy<MysqlTableMetadata, MysqlCompareTableInfo> {
    private static final Logger log = LoggerFactory.getLogger(MysqlStrategy.class);
    @Resource
    private AutoTableProperties autoTableProperties;
    @Resource
    private MysqlTablesMapper mysqlTablesMapper;

    @Override
    public DatabaseDialect dbDialect() {
        return DatabaseDialect.MySQL;
    }

    @Override
    public void dropTable(String tableName) {
        this.mysqlTablesMapper.dropTableByName(tableName);
    }

    @Override
    public boolean checkTableExist(String tableName) {
        return this.mysqlTablesMapper.findTableByTableName(tableName) != null;
    }

    @Override
    public MysqlTableMetadata analyseClass(Class<?> beanClass) {
        MysqlTableMetadata mysqlTableMetadata = TableMetadataBuilder.build(beanClass);
        if (mysqlTableMetadata.getColumnMetadataList().isEmpty()) {
            log.warn("\u626b\u63cf\u53d1\u73b0{}\u6ca1\u6709\u5efa\u8868\u5b57\u6bb5\u8bf7\u68c0\u67e5\uff01", (Object)beanClass.getName());
            return null;
        }
        return mysqlTableMetadata;
    }

    @Override
    public void createTable(MysqlTableMetadata tableMetadata) {
        String sqlStr = CreateTableSqlBuilder.buildSql(tableMetadata);
        log.info("\u6267\u884cSQL\uff1a{}", (Object)sqlStr);
        this.mysqlTablesMapper.executeSql(sqlStr);
    }

    @Override
    public MysqlCompareTableInfo compareTable(MysqlTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableName();
        MysqlCompareTableInfo mysqlCompareTableInfo = new MysqlCompareTableInfo(tableName);
        InformationSchemaTable informationSchemaTable = this.mysqlTablesMapper.findTableByTableName(tableName);
        MysqlStrategy.compareTableProperties(tableMetadata, informationSchemaTable, mysqlCompareTableInfo);
        this.compareColumns(tableMetadata, tableName, mysqlCompareTableInfo);
        List<InformationSchemaStatistics> informationSchemaStatistics = this.mysqlTablesMapper.queryTablePrimaryAndIndex(tableName);
        Map<String, List<InformationSchemaStatistics>> keyColumnGroupByName = informationSchemaStatistics.stream().collect(Collectors.groupingBy(InformationSchemaStatistics::getIndexName));
        List<InformationSchemaStatistics> tablePrimaries = keyColumnGroupByName.remove("PRIMARY");
        MysqlStrategy.comparePrimary(tableMetadata, mysqlCompareTableInfo, tablePrimaries);
        Map<String, List<InformationSchemaStatistics>> tableIndexes = keyColumnGroupByName;
        this.compareIndexes(tableMetadata, mysqlCompareTableInfo, tableIndexes);
        return mysqlCompareTableInfo;
    }

    @Override
    public void modifyTable(MysqlCompareTableInfo mysqlCompareTableInfo) {
        String sqlStr = ModifyTableSqlBuilder.buildSql(mysqlCompareTableInfo);
        log.info("\u5f00\u59cb\u4fee\u6539\u8868\uff1a{}", (Object)mysqlCompareTableInfo.getName());
        log.info("\u6267\u884cSQL\uff1a{}", (Object)sqlStr);
        this.mysqlTablesMapper.executeSql(sqlStr);
        log.info("\u7ed3\u675f\u4fee\u6539\u8868\uff1a{}", (Object)mysqlCompareTableInfo.getName());
    }

    private void compareIndexes(MysqlTableMetadata mysqlTableMetadata, MysqlCompareTableInfo mysqlCompareTableInfo, Map<String, List<InformationSchemaStatistics>> tableIndexs) {
        List<MysqlIndexMetadata> mysqlIndexMetadataList = mysqlTableMetadata.getIndexMetadataList();
        block0: for (MysqlIndexMetadata mysqlIndexMetadata : mysqlIndexMetadataList) {
            String indexName = mysqlIndexMetadata.getName();
            List<InformationSchemaStatistics> theIndexColumns = tableIndexs.remove(indexName);
            if (theIndexColumns == null) {
                mysqlCompareTableInfo.getMysqlIndexMetadataList().add(mysqlIndexMetadata);
                continue;
            }
            theIndexColumns = theIndexColumns.stream().sorted(Comparator.comparing(InformationSchemaStatistics::getSeqInIndex)).collect(Collectors.toList());
            List<MysqlIndexMetadata.IndexColumnParam> columns = mysqlIndexMetadata.getColumns();
            if (theIndexColumns.size() != columns.size()) {
                mysqlCompareTableInfo.getDropIndexList().add(indexName);
                mysqlCompareTableInfo.getMysqlIndexMetadataList().add(mysqlIndexMetadata);
                continue;
            }
            for (int i = 0; i < theIndexColumns.size(); ++i) {
                boolean sortTypeIsDiff;
                InformationSchemaStatistics informationSchemaStatistics = theIndexColumns.get(i);
                IndexSortTypeEnum indexSort = IndexSortTypeEnum.parseFromMysql((String)informationSchemaStatistics.getCollation());
                MysqlIndexMetadata.IndexColumnParam indexColumnParam = columns.get(i);
                IndexSortTypeEnum indexColumnParamSort = indexColumnParam.getSort();
                boolean nameIsDiff = !informationSchemaStatistics.getColumnName().equals(indexColumnParam.getColumn());
                boolean bl = sortTypeIsDiff = indexColumnParamSort != null && indexColumnParamSort != indexSort;
                if (!nameIsDiff && !sortTypeIsDiff) continue;
                mysqlCompareTableInfo.getDropIndexList().add(indexName);
                mysqlCompareTableInfo.getMysqlIndexMetadataList().add(mysqlIndexMetadata);
                continue block0;
            }
        }
        Set<String> needDropIndexes = tableIndexs.keySet();
        if (this.autoTableProperties.getAutoDropIndex().booleanValue() && !needDropIndexes.isEmpty()) {
            mysqlCompareTableInfo.getDropIndexList().addAll(needDropIndexes);
        }
    }

    private static void comparePrimary(MysqlTableMetadata mysqlTableMetadata, MysqlCompareTableInfo mysqlCompareTableInfo, List<InformationSchemaStatistics> tablePrimaries) {
        boolean entityHasPrimary;
        List<MysqlColumnMetadata> primaries = mysqlTableMetadata.getColumnMetadataList().stream().filter(MysqlColumnMetadata::isPrimary).collect(Collectors.toList());
        boolean tableNoPrimary = CollectionUtils.isEmpty(tablePrimaries);
        boolean bl = entityHasPrimary = !primaries.isEmpty();
        if (tableNoPrimary && entityHasPrimary) {
            mysqlCompareTableInfo.setNewPrimaries(primaries);
        }
        if (!tableNoPrimary && !entityHasPrimary) {
            mysqlCompareTableInfo.setDropPrimary(true);
        }
        if (!tableNoPrimary && entityHasPrimary) {
            boolean needResetPrimary;
            boolean sameSize = tablePrimaries.size() == primaries.size();
            boolean bl2 = needResetPrimary = !sameSize;
            if (sameSize) {
                tablePrimaries = tablePrimaries.stream().sorted(Comparator.comparing(InformationSchemaStatistics::getSeqInIndex)).collect(Collectors.toList());
                for (int i = 0; i < tablePrimaries.size(); ++i) {
                    InformationSchemaStatistics tablePrimary = tablePrimaries.get(i);
                    if (tablePrimary.getColumnName().equals(primaries.get(i).getName())) continue;
                    needResetPrimary = true;
                    break;
                }
            }
            if (needResetPrimary) {
                mysqlCompareTableInfo.setNewPrimaries(primaries);
                mysqlCompareTableInfo.setDropPrimary(true);
            }
        }
    }

    private void compareColumns(MysqlTableMetadata mysqlTableMetadata, String tableName, MysqlCompareTableInfo mysqlCompareTableInfo) {
        List<MysqlColumnMetadata> mysqlColumnMetadataList = mysqlTableMetadata.getColumnMetadataList();
        Map columnParamMap = mysqlColumnMetadataList.stream().collect(Collectors.toMap(MysqlColumnMetadata::getName, Functions.identity()));
        List<InformationSchemaColumn> tableColumnList = this.mysqlTablesMapper.findTableEnsembleByTableName(tableName);
        ColumnPositionHelper.generateChangePosition(tableColumnList, mysqlColumnMetadataList);
        for (InformationSchemaColumn informationSchemaColumn : tableColumnList) {
            String columnName = informationSchemaColumn.getColumnName();
            MysqlColumnMetadata mysqlColumnMetadata = (MysqlColumnMetadata)columnParamMap.remove(columnName);
            if (mysqlColumnMetadata != null) {
                boolean columnPositionChanged = mysqlColumnMetadata.getNewPreColumn() != null;
                boolean commentChanged = MysqlStrategy.isCommentChanged(informationSchemaColumn, mysqlColumnMetadata);
                boolean fieldTypeChanged = MysqlStrategy.isFieldTypeChanged(informationSchemaColumn, mysqlColumnMetadata);
                boolean notNullChanged = mysqlColumnMetadata.isNotNull() != informationSchemaColumn.isNotNull();
                boolean fieldIsAutoIncrementChanged = mysqlColumnMetadata.isAutoIncrement() != informationSchemaColumn.isAutoIncrement();
                boolean defaultValueChanged = MysqlStrategy.isDefaultValueChanged(informationSchemaColumn, mysqlColumnMetadata);
                if (!columnPositionChanged && !commentChanged && !fieldTypeChanged && !notNullChanged && !fieldIsAutoIncrementChanged && !defaultValueChanged) continue;
                mysqlCompareTableInfo.addEditColumnMetadata(mysqlColumnMetadata);
                continue;
            }
            if (!this.autoTableProperties.getAutoDropColumn().booleanValue()) continue;
            mysqlCompareTableInfo.getDropColumnList().add(columnName);
        }
        Collection needNewColumns = columnParamMap.values();
        for (MysqlColumnMetadata needNewColumn : needNewColumns) {
            mysqlCompareTableInfo.addNewColumnMetadata(needNewColumn);
        }
    }

    private static boolean isDefaultValueChanged(InformationSchemaColumn informationSchemaColumn, MysqlColumnMetadata mysqlColumnMetadata) {
        String columnDefault = informationSchemaColumn.getColumnDefault();
        DefaultValueEnum defaultValueType = mysqlColumnMetadata.getDefaultValueType();
        if (DefaultValueEnum.isValid((DefaultValueEnum)defaultValueType)) {
            if (defaultValueType == DefaultValueEnum.NULL) {
                return columnDefault != null;
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return !"".equals(columnDefault);
            }
        } else {
            MysqlTypeAndLength columnType = mysqlColumnMetadata.getType();
            if (columnType.isBoolean() && columnDefault != null && columnDefault.startsWith("b'") && columnDefault.endsWith("'")) {
                columnDefault = columnDefault.substring(2, columnDefault.length() - 1);
            }
            String defaultValue = mysqlColumnMetadata.getDefaultValue();
            if (columnType.isFloatNumber() && columnDefault != null && columnDefault.matches("[0-9]+(.[0-9]+)?")) {
                try {
                    columnDefault = String.valueOf(Double.parseDouble(columnDefault));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    defaultValue = String.valueOf(Double.parseDouble(defaultValue));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (columnType.needStringCompatibility() && defaultValue != null && defaultValue.startsWith("'") && defaultValue.endsWith("'")) {
                defaultValue = defaultValue.substring(1, defaultValue.length() - 1);
            }
            return !Objects.equals(defaultValue, columnDefault);
        }
        return false;
    }

    private static boolean isFieldTypeChanged(InformationSchemaColumn informationSchemaColumn, MysqlColumnMetadata mysqlColumnMetadata) {
        MysqlTypeAndLength fieldType = mysqlColumnMetadata.getType();
        if (fieldType.isNoLengthNumber()) {
            return !fieldType.typeName().equalsIgnoreCase(informationSchemaColumn.getDataType());
        }
        String fullType = fieldType.getFullType();
        return !fullType.equals(informationSchemaColumn.getColumnType().toLowerCase());
    }

    private static boolean isCommentChanged(InformationSchemaColumn informationSchemaColumn, MysqlColumnMetadata mysqlColumnMetadata) {
        String fieldComment = mysqlColumnMetadata.getComment();
        return StringUtils.hasText((String)fieldComment) && !fieldComment.equals(informationSchemaColumn.getColumnComment());
    }

    private static void compareTableProperties(MysqlTableMetadata mysqlTableMetadata, InformationSchemaTable tableInformation, MysqlCompareTableInfo mysqlCompareTableInfo) {
        String charset;
        String collate;
        String tableComment = mysqlTableMetadata.getComment();
        String tableCharset = mysqlTableMetadata.getCharacterSet();
        String tableCollate = mysqlTableMetadata.getCollate();
        String tableEngine = mysqlTableMetadata.getEngine();
        if (StringUtils.hasText((String)tableComment) && !tableComment.equals(tableInformation.getTableComment())) {
            mysqlCompareTableInfo.setComment(tableComment);
        }
        if (StringUtils.hasText((String)tableCharset) && StringUtils.hasText((String)(collate = tableInformation.getTableCollation())) && (!tableCharset.equals(charset = collate.substring(0, collate.indexOf("_"))) || !tableCollate.equals(collate))) {
            mysqlCompareTableInfo.setCharacterSet(tableCharset);
            mysqlCompareTableInfo.setCollate(tableCollate);
        }
        if (StringUtils.hasText((String)tableEngine) && !tableEngine.equals(tableInformation.getEngine())) {
            mysqlCompareTableInfo.setEngine(tableEngine);
        }
    }
}

