/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.mysql.builder;

import com.tangzc.mpe.autotable.annotation.enums.IndexTypeEnum;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlColumnMetadata;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlIndexMetadata;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlTableMetadata;
import com.tangzc.mpe.autotable.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CreateTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(CreateTableSqlBuilder.class);

    public static String buildSql(MysqlTableMetadata mysqlTableMetadata) {
        String name = mysqlTableMetadata.getTableName();
        List<MysqlColumnMetadata> mysqlColumnMetadataList = mysqlTableMetadata.getColumnMetadataList();
        List<MysqlIndexMetadata> mysqlIndexMetadataList = mysqlTableMetadata.getIndexMetadataList();
        String collate = mysqlTableMetadata.getCollate();
        String engine = mysqlTableMetadata.getEngine();
        String characterSet = mysqlTableMetadata.getCharacterSet();
        String comment = mysqlTableMetadata.getComment();
        ArrayList<String> addItems = new ArrayList<String>();
        ArrayList<String> primaries = new ArrayList<String>();
        mysqlColumnMetadataList.forEach(columnData -> {
            if (columnData.isPrimary()) {
                columnData.setNotNull(true);
                primaries.add(columnData.getName());
            }
        });
        addItems.add(mysqlColumnMetadataList.stream().map(MysqlColumnMetadata::toColumnSql).collect(Collectors.joining(",")));
        if (!primaries.isEmpty()) {
            String primaryKeySql = CreateTableSqlBuilder.getPrimaryKeySql(primaries);
            addItems.add(primaryKeySql);
        }
        addItems.add(mysqlIndexMetadataList.stream().map(CreateTableSqlBuilder::getIndexSql).sorted().collect(Collectors.joining(",")));
        ArrayList<Object> tableProperties = new ArrayList<Object>();
        if (StringUtils.hasText((String)engine)) {
            tableProperties.add("ENGINE = " + engine);
        }
        if (StringUtils.hasText((String)characterSet)) {
            tableProperties.add("CHARACTER SET = " + characterSet);
        }
        if (StringUtils.hasText((String)collate)) {
            tableProperties.add("COLLATE = " + collate);
        }
        if (StringUtils.hasText((String)comment)) {
            tableProperties.add("COMMENT = '{comment}'".replace("{comment}", comment));
        }
        String addSql = addItems.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        String propertiesSql = tableProperties.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        return "CREATE TABLE `{tableName}` ({addItems}) {tableProperties};".replace("{tableName}", name).replace("{addItems}", addSql).replace("{tableProperties}", propertiesSql);
    }

    public static String getIndexSql(MysqlIndexMetadata mysqlIndexMetadata) {
        return StringHelper.newInstance("{indexType} INDEX `{indexName}`({columns}) {indexComment}").replace("{indexType}", mysqlIndexMetadata.getType() == IndexTypeEnum.UNIQUE ? "UNIQUE" : "").replace("{indexName}", mysqlIndexMetadata.getName()).replace("{columns}", key -> {
            List<MysqlIndexMetadata.IndexColumnParam> columnParams = mysqlIndexMetadata.getColumns();
            return columnParams.stream().map(column -> "`{column}` {sortMode}".replace("{column}", column.getColumn()).replace("{sortMode}", column.getSort() != null ? column.getSort().name() : "")).collect(Collectors.joining(","));
        }).replace("{indexComment}", (String)(StringUtils.hasText((String)mysqlIndexMetadata.getComment()) ? "COMMENT '" + mysqlIndexMetadata.getComment() + "'" : "")).toString();
    }

    public static String getPrimaryKeySql(List<String> primaries) {
        return "PRIMARY KEY ({primaries})".replace("{primaries}", primaries.stream().map(fieldName -> "`" + fieldName + "`").collect(Collectors.joining(",")));
    }
}

