/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.mysql.builder;

import com.tangzc.mpe.autotable.strategy.mysql.builder.CreateTableSqlBuilder;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlColumnMetadata;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlCompareTableInfo;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlIndexMetadata;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ModifyTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(ModifyTableSqlBuilder.class);

    public static String buildSql(MysqlCompareTableInfo mysqlCompareTableInfo) {
        String name = mysqlCompareTableInfo.getName();
        String collate = mysqlCompareTableInfo.getCollate();
        String engine = mysqlCompareTableInfo.getEngine();
        String characterSet = mysqlCompareTableInfo.getCharacterSet();
        String comment = mysqlCompareTableInfo.getComment();
        List<String> dropColumnList = mysqlCompareTableInfo.getDropColumnList();
        List<MysqlCompareTableInfo.MysqlModifyColumnMetadata> modifyMysqlColumnMetadataList = mysqlCompareTableInfo.getModifyMysqlColumnMetadataList();
        List<String> dropIndexList = mysqlCompareTableInfo.getDropIndexList();
        List<MysqlIndexMetadata> mysqlIndexMetadataList = mysqlCompareTableInfo.getMysqlIndexMetadataList();
        ArrayList<Object> modifyItems = new ArrayList<Object>();
        modifyItems.add(dropColumnList.stream().map(dropColumn -> "DROP COLUMN `{columnName}`".replace("{columnName}", (CharSequence)dropColumn)).collect(Collectors.joining(",")));
        modifyItems.add(modifyMysqlColumnMetadataList.stream().sorted(Comparator.comparingInt(modifyColumn -> modifyColumn.getMysqlColumnMetadata().getPosition())).map(modifyColumn -> {
            MysqlColumnMetadata columnMetadata = modifyColumn.getMysqlColumnMetadata();
            if (columnMetadata.isPrimary()) {
                columnMetadata.setNotNull(true);
            }
            String columnSql = columnMetadata.toColumnSql();
            if (modifyColumn.getType() == MysqlCompareTableInfo.ModifyType.MODIFY) {
                return "MODIFY COLUMN " + columnSql;
            }
            return "ADD COLUMN " + columnSql;
        }).collect(Collectors.joining(",")));
        if (mysqlCompareTableInfo.isDropPrimary()) {
            modifyItems.add("DROP PRIMARY KEY");
        }
        if (!mysqlCompareTableInfo.getNewPrimaries().isEmpty()) {
            List<String> primaries = mysqlCompareTableInfo.getNewPrimaries().stream().map(MysqlColumnMetadata::getName).collect(Collectors.toList());
            String primaryKeySql = CreateTableSqlBuilder.getPrimaryKeySql(primaries);
            modifyItems.add("ADD " + primaryKeySql);
        }
        modifyItems.add(dropIndexList.stream().map(dropIndex -> "DROP INDEX `{indexName}`".replace("{indexName}", (CharSequence)dropIndex)).collect(Collectors.joining(",")));
        modifyItems.add(mysqlIndexMetadataList.stream().map(indexParam -> {
            String indexSql = CreateTableSqlBuilder.getIndexSql(indexParam);
            return "ADD " + indexSql;
        }).collect(Collectors.joining(",")));
        if (StringUtils.hasText((String)engine)) {
            modifyItems.add("ENGINE = " + engine);
        }
        if (StringUtils.hasText((String)characterSet)) {
            modifyItems.add("CHARACTER SET = " + characterSet);
        }
        if (StringUtils.hasText((String)collate)) {
            modifyItems.add("COLLATE = " + collate);
        }
        if (StringUtils.hasText((String)comment)) {
            modifyItems.add("COMMENT = '{comment}'".replace("{comment}", comment));
        }
        String modifySql = modifyItems.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        return "ALTER TABLE `{tableName}` {modifyItems};".replace("{tableName}", name).replace("{modifyItems}", modifySql);
    }
}

