/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.mysql.builder;

import com.tangzc.mpe.autotable.annotation.Table;
import com.tangzc.mpe.autotable.annotation.TableIndex;
import com.tangzc.mpe.autotable.annotation.mysql.MysqlCharset;
import com.tangzc.mpe.autotable.annotation.mysql.MysqlEngine;
import com.tangzc.mpe.autotable.properties.AutoTableProperties;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlColumnMetadata;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlIndexMetadata;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlTableMetadata;
import com.tangzc.mpe.autotable.utils.IndexRepeatChecker;
import com.tangzc.mpe.autotable.utils.TableBeanUtils;
import com.tangzc.mpe.magic.BeanClassUtil;
import com.tangzc.mpe.magic.TableColumnNameUtil;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class TableMetadataBuilder {
    private static final Logger log = LoggerFactory.getLogger(TableMetadataBuilder.class);
    private static AutoTableProperties autoTableProperties;

    public static MysqlTableMetadata build(Class<?> clazz) {
        MysqlEngine mysqlEngine;
        String tableName = TableColumnNameUtil.getTableName(clazz);
        MysqlTableMetadata mysqlTableMetadata = new MysqlTableMetadata();
        mysqlTableMetadata.setTableName(tableName);
        Table tableAnno = (Table)AnnotatedElementUtils.findMergedAnnotation(clazz, Table.class);
        assert (tableAnno != null);
        mysqlTableMetadata.setComment(tableAnno.comment());
        MysqlCharset mysqlCharsetAnno = (MysqlCharset)AnnotatedElementUtils.findMergedAnnotation(clazz, MysqlCharset.class);
        if (mysqlCharsetAnno != null) {
            String charset = mysqlCharsetAnno.value();
            Object collate = mysqlCharsetAnno.collate();
            if (!((String)collate).startsWith(charset)) {
                collate = charset + "_general_ci";
            }
            mysqlTableMetadata.setCharacterSet(charset);
            mysqlTableMetadata.setCollate((String)collate);
        }
        if ((mysqlEngine = (MysqlEngine)AnnotatedElementUtils.findMergedAnnotation(clazz, MysqlEngine.class)) != null) {
            mysqlTableMetadata.setEngine(mysqlEngine.value());
        }
        List fields = BeanClassUtil.getAllDeclaredFieldsExcludeStatic(clazz);
        mysqlTableMetadata.setColumnMetadataList(TableMetadataBuilder.getColumnList(clazz, fields));
        mysqlTableMetadata.setIndexMetadataList(TableMetadataBuilder.getIndexList(clazz, fields));
        return mysqlTableMetadata;
    }

    public static List<MysqlColumnMetadata> getColumnList(Class<?> clazz, List<Field> fields) {
        AtomicInteger index = new AtomicInteger(1);
        return fields.stream().filter(field -> TableBeanUtils.isIncludeField(field, clazz)).map(field -> MysqlColumnMetadata.create(clazz, field, index.getAndIncrement())).collect(Collectors.toList());
    }

    public static List<MysqlIndexMetadata> getIndexList(Class<?> clazz, List<Field> fields) {
        IndexRepeatChecker indexRepeatChecker = IndexRepeatChecker.of();
        List<TableIndex> tableIndexes = TableBeanUtils.getTableIndexes(clazz);
        List<MysqlIndexMetadata> indexMetadataList = tableIndexes.stream().map(tableIndex -> MysqlIndexMetadata.create(clazz, tableIndex, TableMetadataBuilder.getAutoTableProperties().getIndexPrefix())).filter(Objects::nonNull).filter(indexMetadata -> indexRepeatChecker.filter(indexMetadata.getName())).collect(Collectors.toList());
        List onFieldIndexMetadata = fields.stream().filter(field -> TableBeanUtils.isIncludeField(field, clazz)).map(field -> MysqlIndexMetadata.create(field, TableMetadataBuilder.getAutoTableProperties().getIndexPrefix())).filter(Objects::nonNull).filter(indexMetadata -> indexRepeatChecker.filter(indexMetadata.getName())).collect(Collectors.toList());
        indexMetadataList.addAll(onFieldIndexMetadata);
        return indexMetadataList;
    }

    public static AutoTableProperties getAutoTableProperties() {
        if (autoTableProperties == null) {
            autoTableProperties = (AutoTableProperties)SpringContextUtil.getBeanOfType(AutoTableProperties.class);
        }
        return autoTableProperties;
    }
}

