/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.mysql.converter.impl;

import com.tangzc.mpe.autotable.strategy.mysql.converter.JavaToMysqlConverter;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlTypeAndLength;
import com.tangzc.mpe.autotable.strategy.mysql.data.enums.MySqlDefaultTypeEnum;
import com.tangzc.mpe.magic.util.EnumUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public class DefaultJavaToMysqlConverter
implements JavaToMysqlConverter {
    public static final Map<Class<?>, MySqlDefaultTypeEnum> JAVA_TO_MYSQL_TYPE_MAP = new HashMap<Class<?>, MySqlDefaultTypeEnum>(){
        {
            this.put(String.class, MySqlDefaultTypeEnum.VARCHAR);
            this.put(Character.class, MySqlDefaultTypeEnum.CHAR);
            this.put(Character.TYPE, MySqlDefaultTypeEnum.CHAR);
            this.put(BigInteger.class, MySqlDefaultTypeEnum.BIGINT);
            this.put(Long.class, MySqlDefaultTypeEnum.BIGINT);
            this.put(Long.TYPE, MySqlDefaultTypeEnum.BIGINT);
            this.put(Integer.class, MySqlDefaultTypeEnum.INT);
            this.put(Integer.TYPE, MySqlDefaultTypeEnum.INT);
            this.put(Boolean.class, MySqlDefaultTypeEnum.BIT);
            this.put(Boolean.TYPE, MySqlDefaultTypeEnum.BIT);
            this.put(Float.class, MySqlDefaultTypeEnum.FLOAT);
            this.put(Float.TYPE, MySqlDefaultTypeEnum.FLOAT);
            this.put(Double.class, MySqlDefaultTypeEnum.DOUBLE);
            this.put(Double.TYPE, MySqlDefaultTypeEnum.DOUBLE);
            this.put(BigDecimal.class, MySqlDefaultTypeEnum.DECIMAL);
            this.put(java.util.Date.class, MySqlDefaultTypeEnum.DATETIME);
            this.put(Date.class, MySqlDefaultTypeEnum.DATE);
            this.put(Timestamp.class, MySqlDefaultTypeEnum.DATETIME);
            this.put(Time.class, MySqlDefaultTypeEnum.TIME);
            this.put(LocalDateTime.class, MySqlDefaultTypeEnum.DATETIME);
            this.put(LocalDate.class, MySqlDefaultTypeEnum.DATE);
            this.put(LocalTime.class, MySqlDefaultTypeEnum.TIME);
            this.put(Short.class, MySqlDefaultTypeEnum.SMALLINT);
            this.put(Short.TYPE, MySqlDefaultTypeEnum.SMALLINT);
        }
    };

    @Override
    public MysqlTypeAndLength convert(Class<?> fieldClass) {
        MySqlDefaultTypeEnum sqlType;
        if (fieldClass.isEnum()) {
            fieldClass = EnumUtil.getEnumFieldSaveDbType(fieldClass);
        }
        if ((sqlType = JAVA_TO_MYSQL_TYPE_MAP.getOrDefault(fieldClass, MySqlDefaultTypeEnum.VARCHAR)) == null) {
            throw new RuntimeException(fieldClass + "\u9ed8\u8ba4\u60c5\u51b5\u4e0b\uff0c\u4e0d\u652f\u6301\u8f6c\u6362\u5230mysql\u7c7b\u578b\uff0c\u5982\u6709\u9700\u8981\u8bf7\u81ea\u884c\u5b9e\u73b0" + JavaToMysqlConverter.class.getName());
        }
        return new MysqlTypeAndLength(sqlType.getLengthDefault(), sqlType.getDecimalLengthDefault(), sqlType.name().toLowerCase());
    }
}

