/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.mysql.data;

import com.tangzc.mpe.autotable.annotation.ColumnDefault;
import com.tangzc.mpe.autotable.annotation.ColumnType;
import com.tangzc.mpe.autotable.annotation.enums.DefaultValueEnum;
import com.tangzc.mpe.autotable.strategy.mysql.ParamValidChecker;
import com.tangzc.mpe.autotable.strategy.mysql.converter.JavaToMysqlConverter;
import com.tangzc.mpe.autotable.strategy.mysql.data.MysqlTypeAndLength;
import com.tangzc.mpe.autotable.utils.StringHelper;
import com.tangzc.mpe.autotable.utils.TableBeanUtils;
import com.tangzc.mpe.magic.TableColumnNameUtil;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MysqlColumnMetadata {
    private static final Logger log = LoggerFactory.getLogger(MysqlColumnMetadata.class);
    private String name;
    private String comment;
    private MysqlTypeAndLength type;
    private boolean notNull;
    private boolean autoIncrement;
    private DefaultValueEnum defaultValueType;
    private String defaultValue;
    private boolean primary;
    private int position;
    private String newPreColumn;

    public static MysqlColumnMetadata create(Class<?> clazz, Field field, int position) {
        MysqlColumnMetadata mysqlColumnMetadata = new MysqlColumnMetadata();
        mysqlColumnMetadata.setName(TableColumnNameUtil.getRealColumnName((Field)field));
        mysqlColumnMetadata.setType(MysqlColumnMetadata.getTypeAndLength(field, clazz));
        mysqlColumnMetadata.setNotNull(TableBeanUtils.isNotNull(field));
        mysqlColumnMetadata.setPrimary(TableBeanUtils.isPrimary(field));
        mysqlColumnMetadata.setAutoIncrement(TableBeanUtils.isAutoIncrement(field));
        mysqlColumnMetadata.setPosition(position);
        ColumnDefault columnDefault = TableBeanUtils.getDefaultValue(field);
        if (columnDefault != null) {
            mysqlColumnMetadata.setDefaultValueType(columnDefault.type());
            Object defaultValue = columnDefault.value();
            if (StringUtils.hasText((String)defaultValue)) {
                MysqlTypeAndLength type = mysqlColumnMetadata.getType();
                if (type.isBoolean() && !"1".equals(defaultValue) && !"0".equals(defaultValue)) {
                    defaultValue = Boolean.parseBoolean((String)defaultValue) ? "1" : "0";
                }
                if (type.isCharString() && !((String)defaultValue).isEmpty() && !((String)defaultValue).startsWith("'") && !((String)defaultValue).endsWith("'")) {
                    defaultValue = "'" + (String)defaultValue + "'";
                }
                if (type.isDateTime() && ((String)defaultValue).matches("(\\d+.?)+") && !((String)defaultValue).startsWith("'") && !((String)defaultValue).endsWith("'")) {
                    defaultValue = "'" + (String)defaultValue + "'";
                }
                mysqlColumnMetadata.setDefaultValue((String)defaultValue);
            }
        }
        mysqlColumnMetadata.setComment(TableBeanUtils.getComment(field));
        ParamValidChecker.checkColumnParam(clazz, field, mysqlColumnMetadata);
        return mysqlColumnMetadata;
    }

    public String toColumnSql() {
        return StringHelper.newInstance("`{columnName}` {typeAndLength} {null} {default} {autoIncrement} {columnComment} {position}").replace("{columnName}", this.getName()).replace("{typeAndLength}", this.getType().getFullType()).replace("{null}", this.isNotNull() ? "NOT NULL" : "NULL").replace("{default}", $ -> {
            DefaultValueEnum defaultValueType = this.getDefaultValueType();
            if (defaultValueType == DefaultValueEnum.NULL) {
                return "DEFAULT NULL";
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return "DEFAULT ''";
            }
            String defaultValue = this.getDefaultValue();
            if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText((String)defaultValue)) {
                return "DEFAULT " + defaultValue;
            }
            return "";
        }).replace("{autoIncrement}", this.isAutoIncrement() ? "AUTO_INCREMENT" : "").replace("{columnComment}", (String)(StringUtils.hasText((String)this.getComment()) ? "COMMENT '" + this.getComment() + "'" : "")).replace("{position}", $ -> {
            if (StringUtils.hasText((String)this.newPreColumn)) {
                return "AFTER `" + this.newPreColumn + "`";
            }
            if ("".equals(this.newPreColumn)) {
                return "FIRST";
            }
            return "";
        }).toString();
    }

    private static MysqlTypeAndLength getTypeAndLength(Field field, Class<?> clazz) {
        Class<?> fieldType = TableBeanUtils.getFieldType(clazz, field);
        JavaToMysqlConverter javaToMysqlConverter = (JavaToMysqlConverter)SpringContextUtil.getBeanOfType(JavaToMysqlConverter.class);
        MysqlTypeAndLength typeAndLength = javaToMysqlConverter.convert(fieldType);
        ColumnType column = TableBeanUtils.getColumnType(field);
        if (column != null) {
            if (!column.value().isEmpty() && !column.value().equals(typeAndLength.getType())) {
                typeAndLength.setType(column.value());
                typeAndLength.setLength(null);
                typeAndLength.setDecimalLength(null);
            }
            if (column.length() >= 0) {
                typeAndLength.setLength(column.length());
            }
            if (column.decimalLength() >= 0) {
                typeAndLength.setDecimalLength(column.decimalLength());
            }
        }
        return typeAndLength;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public MysqlTypeAndLength getType() {
        return this.type;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public DefaultValueEnum getDefaultValueType() {
        return this.defaultValueType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public int getPosition() {
        return this.position;
    }

    public String getNewPreColumn() {
        return this.newPreColumn;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setType(MysqlTypeAndLength type) {
        this.type = type;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setDefaultValueType(DefaultValueEnum defaultValueType) {
        this.defaultValueType = defaultValueType;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setNewPreColumn(String newPreColumn) {
        this.newPreColumn = newPreColumn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MysqlColumnMetadata)) {
            return false;
        }
        MysqlColumnMetadata other = (MysqlColumnMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNotNull() != other.isNotNull()) {
            return false;
        }
        if (this.isAutoIncrement() != other.isAutoIncrement()) {
            return false;
        }
        if (this.isPrimary() != other.isPrimary()) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        MysqlTypeAndLength this$type = this.getType();
        MysqlTypeAndLength other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        DefaultValueEnum this$defaultValueType = this.getDefaultValueType();
        DefaultValueEnum other$defaultValueType = other.getDefaultValueType();
        if (this$defaultValueType == null ? other$defaultValueType != null : !this$defaultValueType.equals(other$defaultValueType)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$newPreColumn = this.getNewPreColumn();
        String other$newPreColumn = other.getNewPreColumn();
        return !(this$newPreColumn == null ? other$newPreColumn != null : !this$newPreColumn.equals(other$newPreColumn));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MysqlColumnMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotNull() ? 79 : 97);
        result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
        result = result * 59 + (this.isPrimary() ? 79 : 97);
        result = result * 59 + this.getPosition();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        MysqlTypeAndLength $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        DefaultValueEnum $defaultValueType = this.getDefaultValueType();
        result = result * 59 + ($defaultValueType == null ? 43 : $defaultValueType.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $newPreColumn = this.getNewPreColumn();
        result = result * 59 + ($newPreColumn == null ? 43 : $newPreColumn.hashCode());
        return result;
    }

    public String toString() {
        return "MysqlColumnMetadata(name=" + this.getName() + ", comment=" + this.getComment() + ", type=" + this.getType() + ", notNull=" + this.isNotNull() + ", autoIncrement=" + this.isAutoIncrement() + ", defaultValueType=" + this.getDefaultValueType() + ", defaultValue=" + this.getDefaultValue() + ", primary=" + this.isPrimary() + ", position=" + this.getPosition() + ", newPreColumn=" + this.getNewPreColumn() + ")";
    }
}

