/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.mysql.data;

import com.google.common.collect.Sets;
import com.tangzc.mpe.autotable.strategy.mysql.data.enums.MySqlDefaultTypeEnum;
import java.util.Set;

public class MysqlTypeAndLength {
    private Integer length;
    private Integer decimalLength;
    private String type;
    private static final Set<String> CHAR_STRING_TYPE = Sets.newHashSet((Object[])new String[]{MySqlDefaultTypeEnum.CHAR.typeName(), MySqlDefaultTypeEnum.VARCHAR.typeName(), MySqlDefaultTypeEnum.TEXT.typeName(), MySqlDefaultTypeEnum.TINYTEXT.typeName(), MySqlDefaultTypeEnum.MEDIUMTEXT.typeName(), MySqlDefaultTypeEnum.LONGTEXT.typeName()});
    private static final Set<String> DATE_TIME_TYPE = Sets.newHashSet((Object[])new String[]{MySqlDefaultTypeEnum.DATE.typeName(), MySqlDefaultTypeEnum.DATETIME.typeName(), MySqlDefaultTypeEnum.YEAR.typeName(), MySqlDefaultTypeEnum.TIME.typeName()});
    private static final Set<String> INTEGER_TYPE = Sets.newHashSet((Object[])new String[]{MySqlDefaultTypeEnum.INT.typeName(), MySqlDefaultTypeEnum.TINYINT.typeName(), MySqlDefaultTypeEnum.SMALLINT.typeName(), MySqlDefaultTypeEnum.MEDIUMINT.typeName(), MySqlDefaultTypeEnum.BIGINT.typeName()});
    private static final Set<String> FLOAT_TYPE = Sets.newHashSet((Object[])new String[]{MySqlDefaultTypeEnum.FLOAT.typeName(), MySqlDefaultTypeEnum.DOUBLE.typeName(), MySqlDefaultTypeEnum.DECIMAL.typeName()});

    public MysqlTypeAndLength(Integer length, Integer decimalLength, String type) {
        if (length != null && length >= 0) {
            this.length = length;
        }
        if (decimalLength != null && decimalLength >= 0) {
            this.decimalLength = decimalLength;
        }
        this.type = type;
    }

    public String typeName() {
        return this.type.toLowerCase();
    }

    public String getFullType() {
        Object typeAndLength = this.typeName();
        if (this.length != null) {
            typeAndLength = (String)typeAndLength + "(" + this.length;
            if (this.decimalLength != null) {
                typeAndLength = (String)typeAndLength + "," + this.decimalLength;
            }
            typeAndLength = (String)typeAndLength + ")";
        }
        return typeAndLength;
    }

    public boolean isCharString() {
        return CHAR_STRING_TYPE.contains(this.typeName());
    }

    public boolean isDateTime() {
        return DATE_TIME_TYPE.contains(this.typeName());
    }

    public boolean needStringCompatibility() {
        return this.isCharString() || this.isDateTime();
    }

    public boolean isBoolean() {
        return MySqlDefaultTypeEnum.BIT.typeName().equalsIgnoreCase(this.typeName());
    }

    public boolean isNumber() {
        return INTEGER_TYPE.contains(this.typeName()) || FLOAT_TYPE.contains(this.typeName());
    }

    public boolean isFloatNumber() {
        return FLOAT_TYPE.contains(this.typeName());
    }

    public boolean isNoLengthNumber() {
        return INTEGER_TYPE.contains(this.typeName());
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getDecimalLength() {
        return this.decimalLength;
    }

    public String getType() {
        return this.type;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setDecimalLength(Integer decimalLength) {
        this.decimalLength = decimalLength;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MysqlTypeAndLength)) {
            return false;
        }
        MysqlTypeAndLength other = (MysqlTypeAndLength)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        Integer this$decimalLength = this.getDecimalLength();
        Integer other$decimalLength = other.getDecimalLength();
        if (this$decimalLength == null ? other$decimalLength != null : !((Object)this$decimalLength).equals(other$decimalLength)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MysqlTypeAndLength;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        Integer $decimalLength = this.getDecimalLength();
        result = result * 59 + ($decimalLength == null ? 43 : ((Object)$decimalLength).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "MysqlTypeAndLength(length=" + this.getLength() + ", decimalLength=" + this.getDecimalLength() + ", type=" + this.getType() + ")";
    }

    public MysqlTypeAndLength() {
    }
}

