/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.pgsql;

import com.tangzc.mpe.autotable.annotation.enums.DefaultValueEnum;
import com.tangzc.mpe.autotable.annotation.enums.IndexSortTypeEnum;
import com.tangzc.mpe.autotable.annotation.enums.IndexTypeEnum;
import com.tangzc.mpe.autotable.constants.DatabaseDialect;
import com.tangzc.mpe.autotable.properties.AutoTableProperties;
import com.tangzc.mpe.autotable.strategy.IStrategy;
import com.tangzc.mpe.autotable.strategy.pgsql.builder.CreateTableSqlBuilder;
import com.tangzc.mpe.autotable.strategy.pgsql.builder.ModifyTableSqlBuilder;
import com.tangzc.mpe.autotable.strategy.pgsql.builder.TableMetadataBuilder;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlColumnMetadata;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlCompareTableInfo;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlIndexMetadata;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlTableMetadata;
import com.tangzc.mpe.autotable.strategy.pgsql.data.dbdata.PgsqlDbColumn;
import com.tangzc.mpe.autotable.strategy.pgsql.data.dbdata.PgsqlDbIndex;
import com.tangzc.mpe.autotable.strategy.pgsql.data.dbdata.PgsqlDbPrimary;
import com.tangzc.mpe.autotable.strategy.pgsql.mapper.PgsqlTablesMapper;
import jakarta.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class PgsqlStrategy
implements IStrategy<PgsqlTableMetadata, PgsqlCompareTableInfo> {
    @Resource
    private PgsqlTablesMapper pgsqlTablesMapper;
    @Resource
    private AutoTableProperties autoTableProperties;

    @Override
    public DatabaseDialect dbDialect() {
        return DatabaseDialect.PostgreSQL;
    }

    @Override
    public void dropTable(String tableName) {
        this.pgsqlTablesMapper.dropTableByName(tableName);
    }

    @Override
    public boolean checkTableExist(String tableName) {
        return this.pgsqlTablesMapper.checkTableExist(tableName) > 0;
    }

    @Override
    public PgsqlTableMetadata analyseClass(Class<?> beanClass) {
        PgsqlTableMetadata pgsqlTableMetadata = TableMetadataBuilder.build(beanClass);
        if (pgsqlTableMetadata.getColumnMetadataList().isEmpty()) {
            log.warn("\u626b\u63cf\u53d1\u73b0{}\u6ca1\u6709\u5efa\u8868\u5b57\u6bb5\u8bf7\u68c0\u67e5\uff01", (Object)beanClass.getName());
            return null;
        }
        return pgsqlTableMetadata;
    }

    @Override
    public void createTable(PgsqlTableMetadata tableMetadata) {
        String buildSql = CreateTableSqlBuilder.buildSql(tableMetadata);
        log.info("\u5f00\u59cb\u521b\u5efa\u8868\uff1a{}", (Object)tableMetadata.getTableName());
        log.info("\u6267\u884cSQL\uff1a{}", (Object)buildSql);
        this.pgsqlTablesMapper.executeSql(buildSql);
        log.info("\u7ed3\u675f\u521b\u5efa\u8868\uff1a{}", (Object)tableMetadata.getTableName());
    }

    @Override
    public PgsqlCompareTableInfo compareTable(PgsqlTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableName();
        PgsqlCompareTableInfo pgsqlCompareTableInfo = new PgsqlCompareTableInfo(tableName);
        this.compareTableInfo(tableMetadata, tableName, pgsqlCompareTableInfo);
        this.compareColumnInfo(tableMetadata, tableName, pgsqlCompareTableInfo);
        this.compareIndexInfo(tableMetadata, tableName, pgsqlCompareTableInfo);
        return pgsqlCompareTableInfo;
    }

    private void compareIndexInfo(PgsqlTableMetadata tableMetadata, String tableName, PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        List<PgsqlDbIndex> pgsqlDbIndices = this.pgsqlTablesMapper.selectTableIndexesDetail(tableName);
        Map pgsqlDbIndexMap = pgsqlDbIndices.stream().filter(idx -> idx.getIndexName().startsWith(this.autoTableProperties.getIndexPrefix())).collect(Collectors.toMap(PgsqlDbIndex::getIndexName, Function.identity()));
        List<PgsqlIndexMetadata> indexMetadataList = tableMetadata.getIndexMetadataList();
        for (PgsqlIndexMetadata pgsqlIndexMetadata : indexMetadataList) {
            String indexColumnParams;
            boolean isUniqueIndex;
            String indexdef;
            String indexName = pgsqlIndexMetadata.getName();
            PgsqlDbIndex dbIndex = (PgsqlDbIndex)pgsqlDbIndexMap.remove(indexName);
            String comment = pgsqlIndexMetadata.getComment();
            String string = comment = StringUtils.hasText((String)comment) ? comment : null;
            if (dbIndex == null) {
                if (StringUtils.hasText((String)comment)) {
                    pgsqlCompareTableInfo.addIndexComment(pgsqlIndexMetadata.getName(), comment);
                }
                pgsqlCompareTableInfo.addNewIndex(pgsqlIndexMetadata);
                continue;
            }
            if (!Objects.equals(dbIndex.getDescription(), comment)) {
                pgsqlCompareTableInfo.addIndexComment(indexName, comment);
            }
            if ((indexdef = dbIndex.getIndexdef().replace("\"", "")).matches("^CREATE " + ((isUniqueIndex = pgsqlIndexMetadata.getType() == IndexTypeEnum.UNIQUE) ? "UNIQUE INDEX" : "INDEX") + " " + indexName + " ON public\\." + tableName + " USING btree \\(" + (indexColumnParams = pgsqlIndexMetadata.getColumns().stream().map(col -> col.getColumn() + (col.getSort() == IndexSortTypeEnum.DESC ? " DESC" : "")).collect(Collectors.joining(", "))) + "\\)$")) continue;
            pgsqlCompareTableInfo.addModifyIndex(pgsqlIndexMetadata);
        }
        Set<String> needRemoveIndexes = pgsqlDbIndexMap.keySet();
        if (!needRemoveIndexes.isEmpty()) {
            pgsqlCompareTableInfo.addDropIndexes(needRemoveIndexes);
        }
    }

    private void compareColumnInfo(PgsqlTableMetadata tableMetadata, String tableName, PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        boolean newPrimary;
        boolean primaryChange;
        List<PgsqlDbColumn> pgsqlDbColumns = this.pgsqlTablesMapper.selectTableFieldDetail(tableName);
        Map pgsqlFieldDetailMap = pgsqlDbColumns.stream().collect(Collectors.toMap(PgsqlDbColumn::getColumnName, Function.identity()));
        List<PgsqlColumnMetadata> columnMetadataList = tableMetadata.getColumnMetadataList();
        for (PgsqlColumnMetadata pgsqlColumnMetadata : columnMetadataList) {
            String columnName = pgsqlColumnMetadata.getName();
            PgsqlDbColumn pgsqlDbColumn = (PgsqlDbColumn)pgsqlFieldDetailMap.remove(columnName);
            if (pgsqlDbColumn == null) {
                pgsqlCompareTableInfo.addColumnComment(pgsqlColumnMetadata.getName(), pgsqlColumnMetadata.getComment());
                pgsqlCompareTableInfo.addNewColumn(pgsqlColumnMetadata);
                continue;
            }
            if (!Objects.equals(pgsqlDbColumn.getDescription(), pgsqlColumnMetadata.getComment())) {
                pgsqlCompareTableInfo.addColumnComment(columnName, pgsqlColumnMetadata.getComment());
            }
            String columnDefault = pgsqlDbColumn.getColumnDefault();
            if (pgsqlColumnMetadata.isPrimary()) continue;
            boolean isTypeDiff = PgsqlStrategy.isTypeDiff(pgsqlColumnMetadata, pgsqlDbColumn);
            boolean isNotnullDiff = pgsqlColumnMetadata.isNotNull() == Objects.equals(pgsqlDbColumn.getIsNullable(), "YES");
            boolean isDefaultDiff = PgsqlStrategy.isDefaultDiff(pgsqlColumnMetadata, columnDefault);
            if (!isTypeDiff && !isNotnullDiff && !isDefaultDiff) continue;
            pgsqlCompareTableInfo.addModifyColumn(pgsqlColumnMetadata);
        }
        Set<String> needRemoveColumns = pgsqlFieldDetailMap.keySet();
        if (!needRemoveColumns.isEmpty()) {
            pgsqlCompareTableInfo.addDropColumns(needRemoveColumns);
        }
        List<PgsqlColumnMetadata> primaryColumnList = columnMetadataList.stream().filter(PgsqlColumnMetadata::isPrimary).collect(Collectors.toList());
        PgsqlDbPrimary pgsqlDbPrimary = this.pgsqlTablesMapper.selectPrimaryKeyName(tableName);
        boolean removePrimary = primaryColumnList.isEmpty() && pgsqlDbPrimary != null;
        String newPrimaryColumns = primaryColumnList.stream().map(PgsqlColumnMetadata::getName).collect(Collectors.joining(","));
        boolean bl = primaryChange = pgsqlDbPrimary != null && !Objects.equals(pgsqlDbPrimary.getColumns(), newPrimaryColumns);
        if (removePrimary || primaryChange) {
            pgsqlCompareTableInfo.setDropPrimaryKeyName(pgsqlDbPrimary.getPrimaryName());
        }
        boolean bl2 = newPrimary = !primaryColumnList.isEmpty() && pgsqlDbPrimary == null;
        if (newPrimary || primaryChange) {
            pgsqlCompareTableInfo.addNewPrimary(primaryColumnList);
        }
    }

    private static boolean isTypeDiff(PgsqlColumnMetadata pgsqlColumnMetadata, PgsqlDbColumn pgsqlDbColumn) {
        String dataTypeFormat = pgsqlDbColumn.getDataTypeFormat().toLowerCase();
        String fullType = pgsqlColumnMetadata.getType().getFullType().toLowerCase();
        if (dataTypeFormat.startsWith("int")) {
            return !dataTypeFormat.startsWith(fullType);
        }
        return !Objects.equals(fullType, dataTypeFormat);
    }

    private static boolean isDefaultDiff(PgsqlColumnMetadata pgsqlColumnMetadata, String columnDefault) {
        if (columnDefault != null && columnDefault.matches("^'.*'::character varying$")) {
            columnDefault = columnDefault.replace("::character varying", "");
        } else if (columnDefault != null && columnDefault.matches("^'.*'::bpchar$")) {
            columnDefault = columnDefault.replace("::bpchar", "");
        } else if (columnDefault != null && columnDefault.matches("^'.*'::date$")) {
            columnDefault = columnDefault.replace("::date", "");
        } else if (columnDefault != null && columnDefault.matches("^'.*'::time without time zone$")) {
            columnDefault = columnDefault.replace("::time without time zone", "");
        } else if (columnDefault != null && columnDefault.matches("^'.*'::timestamp without time zone$")) {
            columnDefault = columnDefault.replace("::timestamp without time zone", "");
        }
        DefaultValueEnum defaultValueType = pgsqlColumnMetadata.getDefaultValueType();
        if (DefaultValueEnum.isValid((DefaultValueEnum)defaultValueType)) {
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return !"''".equals(columnDefault);
            }
            if (defaultValueType == DefaultValueEnum.NULL) {
                return columnDefault != null;
            }
        } else {
            String defaultValue = pgsqlColumnMetadata.getDefaultValue();
            return !Objects.equals(defaultValue, columnDefault);
        }
        return false;
    }

    private void compareTableInfo(PgsqlTableMetadata tableMetadata, String tableName, PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        String tableDescription = this.pgsqlTablesMapper.selectTableDescription(tableName);
        if (!Objects.equals(tableDescription, tableMetadata.getComment())) {
            pgsqlCompareTableInfo.setComment(tableMetadata.getComment());
        }
    }

    @Override
    public void modifyTable(PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        String buildSql = ModifyTableSqlBuilder.buildSql(pgsqlCompareTableInfo);
        log.info("\u5f00\u59cb\u4fee\u6539\u8868\uff1a{}", (Object)pgsqlCompareTableInfo.getName());
        log.info("\u6267\u884cSQL\uff1a{}", (Object)buildSql);
        this.pgsqlTablesMapper.executeSql(buildSql);
        log.info("\u7ed3\u675f\u4fee\u6539\u8868\uff1a{}", (Object)pgsqlCompareTableInfo.getName());
    }
}

