/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.pgsql.builder;

import com.tangzc.mpe.autotable.annotation.enums.IndexTypeEnum;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlColumnMetadata;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlIndexMetadata;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlTableMetadata;
import com.tangzc.mpe.autotable.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CreateTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(CreateTableSqlBuilder.class);

    public static String buildSql(PgsqlTableMetadata pgsqlTableMetadata) {
        String tableName = pgsqlTableMetadata.getTableName();
        String createTableSql = CreateTableSqlBuilder.getCreateTableSql(pgsqlTableMetadata);
        List<PgsqlIndexMetadata> indexMetadataList = pgsqlTableMetadata.getIndexMetadataList();
        String createIndexSql = CreateTableSqlBuilder.getCreateIndexSql(tableName, indexMetadataList);
        String addCommentSql = CreateTableSqlBuilder.getAddColumnCommentSql(pgsqlTableMetadata);
        return createTableSql + "\n" + createIndexSql + "\n" + addCommentSql;
    }

    public static String getCreateIndexSql(String tableName, List<PgsqlIndexMetadata> indexMetadataList) {
        return indexMetadataList.stream().map(pgsqlIndexMetadata -> StringHelper.newInstance("CREATE {indexType} INDEX \"{indexName}\" ON \"{tableName}\" ({columns});").replace("{indexType}", pgsqlIndexMetadata.getType() == IndexTypeEnum.UNIQUE ? "UNIQUE" : "").replace("{indexName}", pgsqlIndexMetadata.getName()).replace("{tableName}", tableName).replace("{columns}", key -> {
            List<PgsqlIndexMetadata.IndexColumnParam> columnParams = pgsqlIndexMetadata.getColumns();
            return columnParams.stream().map(column -> "\"{column}\" {sortMode}".replace("{column}", column.getColumn()).replace("{sortMode}", column.getSort() != null ? column.getSort().name() : "")).collect(Collectors.joining(","));
        }).toString()).collect(Collectors.joining("\n"));
    }

    private static String getAddColumnCommentSql(PgsqlTableMetadata pgsqlTableMetadata) {
        String tableName = pgsqlTableMetadata.getTableName();
        String comment = pgsqlTableMetadata.getComment();
        List<PgsqlColumnMetadata> columnMetadataList = pgsqlTableMetadata.getColumnMetadataList();
        List<PgsqlIndexMetadata> indexMetadataList = pgsqlTableMetadata.getIndexMetadataList();
        return CreateTableSqlBuilder.getAddColumnCommentSql(tableName, comment, columnMetadataList.stream().collect(Collectors.toMap(PgsqlColumnMetadata::getName, PgsqlColumnMetadata::getComment)), indexMetadataList.stream().collect(Collectors.toMap(PgsqlIndexMetadata::getName, PgsqlIndexMetadata::getComment)));
    }

    public static String getAddColumnCommentSql(String tableName, String tableComment, Map<String, String> columnCommentMap, Map<String, String> indexCommentMap) {
        ArrayList<String> commentList = new ArrayList<String>();
        if (StringUtils.hasText((String)tableComment)) {
            String addTableComment = "COMMENT ON TABLE \"{tableName}\" IS '{comment}';".replace("{tableName}", tableName).replace("{comment}", tableComment);
            commentList.add(addTableComment);
        }
        columnCommentMap.entrySet().stream().map(columnComment -> "COMMENT ON COLUMN \"{tableName}\".\"{name}\" IS '{comment}';".replace("{tableName}", tableName).replace("{name}", (CharSequence)columnComment.getKey()).replace("{comment}", (CharSequence)columnComment.getValue())).forEach(commentList::add);
        indexCommentMap.entrySet().stream().map(indexComment -> "COMMENT ON INDEX \"public\".\"{name}\" IS '{comment}';".replace("{name}", (CharSequence)indexComment.getKey()).replace("{comment}", (CharSequence)indexComment.getValue())).forEach(commentList::add);
        return String.join((CharSequence)"\n", commentList);
    }

    private static String getCreateTableSql(PgsqlTableMetadata pgsqlTableMetadata) {
        String name = pgsqlTableMetadata.getTableName();
        List<PgsqlColumnMetadata> columnMetadataList = pgsqlTableMetadata.getColumnMetadataList();
        ArrayList<String> columnList = new ArrayList<String>();
        ArrayList<String> primaries = new ArrayList<String>();
        columnMetadataList.forEach(columnData -> {
            if (columnData.isPrimary()) {
                columnData.setNotNull(true);
                primaries.add(columnData.getName());
            }
        });
        columnList.add(columnMetadataList.stream().map(PgsqlColumnMetadata::toColumnSql).collect(Collectors.joining(",")));
        if (!primaries.isEmpty()) {
            String primaryKeySql = CreateTableSqlBuilder.getPrimaryKeySql(primaries);
            columnList.add(primaryKeySql);
        }
        String addSql = columnList.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        return "CREATE TABLE \"{tableName}\" ({columnList});".replace("{tableName}", name).replace("{columnList}", addSql);
    }

    private static String getPrimaryKeySql(List<String> primaries) {
        return "PRIMARY KEY ({primaries})".replace("{primaries}", primaries.stream().map(fieldName -> "\"" + fieldName + "\"").collect(Collectors.joining(",")));
    }
}

