/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.pgsql.builder;

import com.tangzc.mpe.autotable.annotation.enums.DefaultValueEnum;
import com.tangzc.mpe.autotable.strategy.pgsql.builder.CreateTableSqlBuilder;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlColumnMetadata;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlCompareTableInfo;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class ModifyTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(ModifyTableSqlBuilder.class);

    public static String buildSql(PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        String tableName = pgsqlCompareTableInfo.getName();
        String tableComment = pgsqlCompareTableInfo.getComment();
        Map<String, String> columnComment = pgsqlCompareTableInfo.getColumnComment();
        Map<String, String> indexComment = pgsqlCompareTableInfo.getIndexComment();
        ArrayList<CallSite> alterTableSqlList = new ArrayList<CallSite>();
        String primaryKeyName = pgsqlCompareTableInfo.getDropPrimaryKeyName();
        if (StringUtils.hasText((String)primaryKeyName)) {
            alterTableSqlList.add((CallSite)((Object)("  DROP CONSTRAINT \"" + primaryKeyName + "\"")));
        }
        List<String> dropColumnList = pgsqlCompareTableInfo.getDropColumnList();
        dropColumnList.stream().map(columnName -> "  DROP COLUMN \"" + columnName + "\"").forEach(alterTableSqlList::add);
        List<PgsqlColumnMetadata> newColumnList = pgsqlCompareTableInfo.getNewColumnMetadataList();
        newColumnList.stream().map(column -> "  ADD COLUMN " + column.toColumnSql()).forEach(alterTableSqlList::add);
        List<PgsqlColumnMetadata> modifyColumnList = pgsqlCompareTableInfo.getModifyColumnMetadataList();
        for (PgsqlColumnMetadata columnMetadata : modifyColumnList) {
            String columnName2 = columnMetadata.getName();
            alterTableSqlList.add((CallSite)((Object)("  ALTER COLUMN \"" + columnName2 + "\" TYPE " + columnMetadata.getType().getFullType())));
            alterTableSqlList.add((CallSite)((Object)("  ALTER COLUMN \"" + columnName2 + "\" " + (columnMetadata.isNotNull() ? "SET" : "DROP") + " NOT NULL")));
            String defaultVal = "NULL";
            DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
            if (DefaultValueEnum.EMPTY_STRING == defaultValueType) {
                defaultVal = "''";
            } else {
                String defaultValue = columnMetadata.getDefaultValue();
                if (StringUtils.hasText((String)defaultValue)) {
                    defaultVal = defaultValue;
                }
            }
            alterTableSqlList.add((CallSite)((Object)("  ALTER COLUMN \"" + columnName2 + "\" SET DEFAULT " + defaultVal)));
        }
        List<PgsqlColumnMetadata> newPrimaries = pgsqlCompareTableInfo.getNewPrimaries();
        if (!newPrimaries.isEmpty()) {
            String primaryColumns = newPrimaries.stream().map(col -> "\"" + col.getName() + "\"").collect(Collectors.joining(", "));
            if (StringUtils.hasText((String)primaryKeyName)) {
                alterTableSqlList.add((CallSite)((Object)("  ADD CONSTRAINT \"" + primaryKeyName + "\" PRIMARY KEY (" + primaryColumns + ")")));
            } else {
                alterTableSqlList.add((CallSite)((Object)("  ADD PRIMARY KEY (" + primaryColumns + ")")));
            }
        }
        String alterTableSql = alterTableSqlList.isEmpty() ? "" : "ALTER TABLE \"" + tableName + "\" \n" + String.join((CharSequence)",\n", alterTableSqlList) + ";";
        String addColumnCommentSql = CreateTableSqlBuilder.getAddColumnCommentSql(tableName, tableComment, columnComment, indexComment);
        List<String> dropIndexList = pgsqlCompareTableInfo.getDropIndexList();
        String dropIndexSql = dropIndexList.stream().map(indexName -> "DROP INDEX \"public\".\"" + indexName + "\";").collect(Collectors.joining("\n"));
        String createIndexSql = CreateTableSqlBuilder.getCreateIndexSql(tableName, pgsqlCompareTableInfo.getIndexMetadataList());
        return dropIndexSql + "\n" + alterTableSql + "\n" + addColumnCommentSql + "\n" + createIndexSql;
    }
}

