/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.pgsql.builder;

import com.tangzc.mpe.autotable.annotation.Table;
import com.tangzc.mpe.autotable.annotation.TableIndex;
import com.tangzc.mpe.autotable.properties.AutoTableProperties;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlColumnMetadata;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlIndexMetadata;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlTableMetadata;
import com.tangzc.mpe.autotable.utils.IndexRepeatChecker;
import com.tangzc.mpe.autotable.utils.TableBeanUtils;
import com.tangzc.mpe.magic.BeanClassUtil;
import com.tangzc.mpe.magic.TableColumnNameUtil;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class TableMetadataBuilder {
    private static final Logger log = LoggerFactory.getLogger(TableMetadataBuilder.class);
    private static AutoTableProperties autoTableProperties;

    public static PgsqlTableMetadata build(Class<?> clazz) {
        String tableName = TableColumnNameUtil.getTableName(clazz);
        PgsqlTableMetadata pgsqlTableMetadata = new PgsqlTableMetadata();
        pgsqlTableMetadata.setTableName(tableName);
        Table tableAnno = (Table)AnnotatedElementUtils.findMergedAnnotation(clazz, Table.class);
        assert (tableAnno != null);
        pgsqlTableMetadata.setComment(tableAnno.comment());
        List fields = BeanClassUtil.getAllDeclaredFieldsExcludeStatic(clazz);
        pgsqlTableMetadata.setColumnMetadataList(TableMetadataBuilder.getColumnList(clazz, fields));
        pgsqlTableMetadata.setIndexMetadataList(TableMetadataBuilder.getIndexList(clazz, fields));
        return pgsqlTableMetadata;
    }

    public static List<PgsqlColumnMetadata> getColumnList(Class<?> clazz, List<Field> fields) {
        return fields.stream().filter(field -> TableBeanUtils.isIncludeField(field, clazz)).map(field -> PgsqlColumnMetadata.create(clazz, field)).collect(Collectors.toList());
    }

    public static List<PgsqlIndexMetadata> getIndexList(Class<?> clazz, List<Field> fields) {
        IndexRepeatChecker indexRepeatChecker = IndexRepeatChecker.of();
        List<TableIndex> tableIndexes = TableBeanUtils.getTableIndexes(clazz);
        List<PgsqlIndexMetadata> indexMetadataList = tableIndexes.stream().map(tableIndex -> PgsqlIndexMetadata.create(clazz, tableIndex, TableMetadataBuilder.getAutoTableProperties().getIndexPrefix())).filter(Objects::nonNull).filter(indexMetadata -> indexRepeatChecker.filter(indexMetadata.getName())).collect(Collectors.toList());
        List onFieldIndexMetadata = fields.stream().filter(field -> TableBeanUtils.isIncludeField(field, clazz)).map(field -> PgsqlIndexMetadata.create(field, TableMetadataBuilder.getAutoTableProperties().getIndexPrefix())).filter(Objects::nonNull).filter(indexMetadata -> indexRepeatChecker.filter(indexMetadata.getName())).collect(Collectors.toList());
        indexMetadataList.addAll(onFieldIndexMetadata);
        return indexMetadataList;
    }

    public static AutoTableProperties getAutoTableProperties() {
        if (autoTableProperties == null) {
            autoTableProperties = (AutoTableProperties)SpringContextUtil.getBeanOfType(AutoTableProperties.class);
        }
        return autoTableProperties;
    }
}

