/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.pgsql.converter.impl;

import com.tangzc.mpe.autotable.strategy.pgsql.converter.JavaToPgsqlConverter;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlTypeAndLength;
import com.tangzc.mpe.autotable.strategy.pgsql.data.enums.PgsqlDefaultTypeEnum;
import com.tangzc.mpe.magic.util.EnumUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public class DefaultJavaToPgsqlConverter
implements JavaToPgsqlConverter {
    public static final Map<Class<?>, PgsqlDefaultTypeEnum> JAVA_TO_PGSQL_TYPE_MAP = new HashMap<Class<?>, PgsqlDefaultTypeEnum>(){
        {
            this.put(String.class, PgsqlDefaultTypeEnum.VARCHAR);
            this.put(Character.class, PgsqlDefaultTypeEnum.CHAR);
            this.put(Character.TYPE, PgsqlDefaultTypeEnum.CHAR);
            this.put(BigInteger.class, PgsqlDefaultTypeEnum.INT8);
            this.put(Long.class, PgsqlDefaultTypeEnum.INT8);
            this.put(Long.TYPE, PgsqlDefaultTypeEnum.INT8);
            this.put(Integer.class, PgsqlDefaultTypeEnum.INT4);
            this.put(Integer.TYPE, PgsqlDefaultTypeEnum.INT4);
            this.put(Boolean.class, PgsqlDefaultTypeEnum.BOOL);
            this.put(Boolean.TYPE, PgsqlDefaultTypeEnum.BOOL);
            this.put(Float.class, PgsqlDefaultTypeEnum.FLOAT4);
            this.put(Float.TYPE, PgsqlDefaultTypeEnum.FLOAT4);
            this.put(Double.class, PgsqlDefaultTypeEnum.FLOAT8);
            this.put(Double.TYPE, PgsqlDefaultTypeEnum.FLOAT8);
            this.put(BigDecimal.class, PgsqlDefaultTypeEnum.NUMERIC);
            this.put(java.util.Date.class, PgsqlDefaultTypeEnum.TIMESTAMP);
            this.put(Date.class, PgsqlDefaultTypeEnum.TIMESTAMP);
            this.put(Timestamp.class, PgsqlDefaultTypeEnum.TIMESTAMP);
            this.put(Time.class, PgsqlDefaultTypeEnum.TIME);
            this.put(LocalDateTime.class, PgsqlDefaultTypeEnum.TIMESTAMP);
            this.put(LocalDate.class, PgsqlDefaultTypeEnum.DATE);
            this.put(LocalTime.class, PgsqlDefaultTypeEnum.TIME);
            this.put(Short.class, PgsqlDefaultTypeEnum.INT2);
            this.put(Short.TYPE, PgsqlDefaultTypeEnum.INT2);
        }
    };

    @Override
    public PgsqlTypeAndLength convert(Class<?> fieldClass) {
        PgsqlDefaultTypeEnum sqlType;
        if (fieldClass.isEnum()) {
            fieldClass = EnumUtil.getEnumFieldSaveDbType(fieldClass);
        }
        if ((sqlType = JAVA_TO_PGSQL_TYPE_MAP.getOrDefault(fieldClass, PgsqlDefaultTypeEnum.VARCHAR)) == null) {
            throw new RuntimeException(fieldClass + "\u9ed8\u8ba4\u60c5\u51b5\u4e0b\uff0c\u4e0d\u652f\u6301\u8f6c\u6362\u5230pgsql\u7c7b\u578b\uff0c\u5982\u6709\u9700\u8981\u8bf7\u81ea\u884c\u5b9e\u73b0" + JavaToPgsqlConverter.class.getName());
        }
        return new PgsqlTypeAndLength(sqlType.getLengthDefault(), sqlType.getDecimalLengthDefault(), sqlType.name().toLowerCase());
    }
}

