/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.pgsql.data;

import com.tangzc.mpe.autotable.annotation.ColumnDefault;
import com.tangzc.mpe.autotable.annotation.ColumnType;
import com.tangzc.mpe.autotable.annotation.enums.DefaultValueEnum;
import com.tangzc.mpe.autotable.strategy.pgsql.converter.JavaToPgsqlConverter;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlTypeAndLength;
import com.tangzc.mpe.autotable.utils.StringHelper;
import com.tangzc.mpe.autotable.utils.TableBeanUtils;
import com.tangzc.mpe.magic.TableColumnNameUtil;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class PgsqlColumnMetadata {
    private static final Logger log = LoggerFactory.getLogger(PgsqlColumnMetadata.class);
    private String name;
    private String comment;
    private PgsqlTypeAndLength type;
    private boolean notNull;
    private boolean autoIncrement;
    private DefaultValueEnum defaultValueType;
    private String defaultValue;
    private boolean primary;

    public String getDefaultValue() {
        if (!StringUtils.hasText((String)this.defaultValue)) {
            return null;
        }
        if (this.type.isBoolean()) {
            if ("1".equals(this.defaultValue)) {
                return "true";
            }
            if ("0".equals(this.defaultValue)) {
                return "false";
            }
        }
        if (this.type.isCharString() && !this.defaultValue.startsWith("'") && !this.defaultValue.endsWith("'")) {
            return "'" + this.defaultValue + "'";
        }
        if (this.type.isTime() && this.defaultValue.matches("(\\d+.?)+") && !this.defaultValue.startsWith("'") && !this.defaultValue.endsWith("'")) {
            return "'" + this.defaultValue + "'";
        }
        return this.defaultValue;
    }

    public static PgsqlColumnMetadata create(Class<?> clazz, Field field) {
        PgsqlColumnMetadata pgsqlColumnMetadata = new PgsqlColumnMetadata();
        pgsqlColumnMetadata.setName(TableColumnNameUtil.getRealColumnName((Field)field));
        pgsqlColumnMetadata.setType(PgsqlColumnMetadata.getTypeAndLength(field, clazz));
        pgsqlColumnMetadata.setNotNull(TableBeanUtils.isNotNull(field));
        pgsqlColumnMetadata.setPrimary(TableBeanUtils.isPrimary(field));
        pgsqlColumnMetadata.setAutoIncrement(TableBeanUtils.isAutoIncrement(field));
        ColumnDefault columnDefault = TableBeanUtils.getDefaultValue(field);
        if (columnDefault != null) {
            pgsqlColumnMetadata.setDefaultValueType(columnDefault.type());
            Object defaultValue = columnDefault.value();
            if (StringUtils.hasText((String)defaultValue)) {
                PgsqlTypeAndLength type = pgsqlColumnMetadata.getType();
                if (type.isCharString() && !((String)defaultValue).isEmpty() && !((String)defaultValue).startsWith("'") && !((String)defaultValue).endsWith("'")) {
                    defaultValue = "'" + (String)defaultValue + "'";
                }
                pgsqlColumnMetadata.setDefaultValue((String)defaultValue);
            }
        }
        pgsqlColumnMetadata.setComment(TableBeanUtils.getComment(field));
        return pgsqlColumnMetadata;
    }

    public String toColumnSql() {
        return StringHelper.newInstance("\"{columnName}\" {typeAndLength} {null} {default}").replace("{columnName}", this.getName()).replace("{typeAndLength}", key -> {
            PgsqlTypeAndLength typeAndLength = this.getType();
            if (this.autoIncrement) {
                return "serial";
            }
            return typeAndLength.getFullType();
        }).replace("{null}", this.isNotNull() ? "NOT NULL" : "").replace("{default}", key -> {
            DefaultValueEnum defaultValueType = this.getDefaultValueType();
            if (defaultValueType == DefaultValueEnum.NULL) {
                return "DEFAULT NULL";
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return "DEFAULT ''";
            }
            String defaultValue = this.getDefaultValue();
            if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText((String)defaultValue)) {
                return "DEFAULT " + defaultValue;
            }
            return "";
        }).toString();
    }

    private static PgsqlTypeAndLength getTypeAndLength(Field field, Class<?> clazz) {
        Class<?> fieldType = TableBeanUtils.getFieldType(clazz, field);
        JavaToPgsqlConverter javaToPgsqlConverter = (JavaToPgsqlConverter)SpringContextUtil.getBeanOfType(JavaToPgsqlConverter.class);
        PgsqlTypeAndLength typeAndLength = javaToPgsqlConverter.convert(fieldType);
        ColumnType column = TableBeanUtils.getColumnType(field);
        if (column != null) {
            if (StringUtils.hasText((String)column.value()) && !column.value().equalsIgnoreCase(typeAndLength.getType())) {
                typeAndLength.setType(column.value());
                typeAndLength.setLength(null);
                typeAndLength.setDecimalLength(null);
            }
            if (column.length() >= 0) {
                typeAndLength.setLength(column.length());
            }
            if (column.decimalLength() >= 0) {
                typeAndLength.setDecimalLength(column.decimalLength());
            }
        }
        return typeAndLength;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public PgsqlTypeAndLength getType() {
        return this.type;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public DefaultValueEnum getDefaultValueType() {
        return this.defaultValueType;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setType(PgsqlTypeAndLength type) {
        this.type = type;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setDefaultValueType(DefaultValueEnum defaultValueType) {
        this.defaultValueType = defaultValueType;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PgsqlColumnMetadata)) {
            return false;
        }
        PgsqlColumnMetadata other = (PgsqlColumnMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNotNull() != other.isNotNull()) {
            return false;
        }
        if (this.isAutoIncrement() != other.isAutoIncrement()) {
            return false;
        }
        if (this.isPrimary() != other.isPrimary()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        PgsqlTypeAndLength this$type = this.getType();
        PgsqlTypeAndLength other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        DefaultValueEnum this$defaultValueType = this.getDefaultValueType();
        DefaultValueEnum other$defaultValueType = other.getDefaultValueType();
        if (this$defaultValueType == null ? other$defaultValueType != null : !this$defaultValueType.equals(other$defaultValueType)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PgsqlColumnMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotNull() ? 79 : 97);
        result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
        result = result * 59 + (this.isPrimary() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        PgsqlTypeAndLength $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        DefaultValueEnum $defaultValueType = this.getDefaultValueType();
        result = result * 59 + ($defaultValueType == null ? 43 : $defaultValueType.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public String toString() {
        return "PgsqlColumnMetadata(name=" + this.getName() + ", comment=" + this.getComment() + ", type=" + this.getType() + ", notNull=" + this.isNotNull() + ", autoIncrement=" + this.isAutoIncrement() + ", defaultValueType=" + this.getDefaultValueType() + ", defaultValue=" + this.getDefaultValue() + ", primary=" + this.isPrimary() + ")";
    }
}

