/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.pgsql.data;

import com.tangzc.mpe.autotable.strategy.CompareTableInfo;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlColumnMetadata;
import com.tangzc.mpe.autotable.strategy.pgsql.data.PgsqlIndexMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.springframework.util.StringUtils;

public class PgsqlCompareTableInfo
implements CompareTableInfo {
    @NonNull
    private final String name;
    private String comment;
    private List<PgsqlColumnMetadata> newPrimaries = new ArrayList<PgsqlColumnMetadata>();
    private String dropPrimaryKeyName;
    private Map<String, String> columnComment = new HashMap<String, String>();
    private Map<String, String> indexComment = new HashMap<String, String>();
    private List<String> dropColumnList = new ArrayList<String>();
    private List<PgsqlColumnMetadata> modifyColumnMetadataList = new ArrayList<PgsqlColumnMetadata>();
    private List<PgsqlColumnMetadata> newColumnMetadataList = new ArrayList<PgsqlColumnMetadata>();
    private List<String> dropIndexList = new ArrayList<String>();
    private List<PgsqlIndexMetadata> indexMetadataList = new ArrayList<PgsqlIndexMetadata>();

    @Override
    public boolean needModify() {
        return StringUtils.hasText((String)this.comment) || StringUtils.hasText((String)this.dropPrimaryKeyName) || !this.newPrimaries.isEmpty() || !this.columnComment.isEmpty() || !this.indexComment.isEmpty() || !this.dropColumnList.isEmpty() || !this.modifyColumnMetadataList.isEmpty() || !this.newColumnMetadataList.isEmpty() || !this.dropIndexList.isEmpty() || !this.indexMetadataList.isEmpty();
    }

    public void addColumnComment(String columnName, String newComment) {
        this.columnComment.put(columnName, newComment);
    }

    public void addNewColumn(PgsqlColumnMetadata columnMetadata) {
        this.newColumnMetadataList.add(columnMetadata);
    }

    public void addModifyColumn(PgsqlColumnMetadata columnMetadata) {
        this.modifyColumnMetadataList.add(columnMetadata);
    }

    public void addDropColumns(Set<String> dropColumnList) {
        this.dropColumnList.addAll(dropColumnList);
    }

    public void addNewIndex(PgsqlIndexMetadata pgsqlIndexMetadata) {
        this.indexMetadataList.add(pgsqlIndexMetadata);
    }

    public void addModifyIndex(PgsqlIndexMetadata pgsqlIndexMetadata) {
        this.dropIndexList.add(pgsqlIndexMetadata.getName());
        this.indexMetadataList.add(pgsqlIndexMetadata);
    }

    public void addIndexComment(@NonNull String indexName, String newComment) {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        this.indexComment.put(indexName, newComment);
    }

    public void addDropIndexes(Set<String> indexNameList) {
        this.dropIndexList.addAll(indexNameList);
    }

    public void addNewPrimary(List<PgsqlColumnMetadata> pgsqlColumnMetadata) {
        this.newPrimaries.addAll(pgsqlColumnMetadata);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public List<PgsqlColumnMetadata> getNewPrimaries() {
        return this.newPrimaries;
    }

    public String getDropPrimaryKeyName() {
        return this.dropPrimaryKeyName;
    }

    public Map<String, String> getColumnComment() {
        return this.columnComment;
    }

    public Map<String, String> getIndexComment() {
        return this.indexComment;
    }

    public List<String> getDropColumnList() {
        return this.dropColumnList;
    }

    public List<PgsqlColumnMetadata> getModifyColumnMetadataList() {
        return this.modifyColumnMetadataList;
    }

    public List<PgsqlColumnMetadata> getNewColumnMetadataList() {
        return this.newColumnMetadataList;
    }

    public List<String> getDropIndexList() {
        return this.dropIndexList;
    }

    public List<PgsqlIndexMetadata> getIndexMetadataList() {
        return this.indexMetadataList;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setNewPrimaries(List<PgsqlColumnMetadata> newPrimaries) {
        this.newPrimaries = newPrimaries;
    }

    public void setDropPrimaryKeyName(String dropPrimaryKeyName) {
        this.dropPrimaryKeyName = dropPrimaryKeyName;
    }

    public void setColumnComment(Map<String, String> columnComment) {
        this.columnComment = columnComment;
    }

    public void setIndexComment(Map<String, String> indexComment) {
        this.indexComment = indexComment;
    }

    public void setDropColumnList(List<String> dropColumnList) {
        this.dropColumnList = dropColumnList;
    }

    public void setModifyColumnMetadataList(List<PgsqlColumnMetadata> modifyColumnMetadataList) {
        this.modifyColumnMetadataList = modifyColumnMetadataList;
    }

    public void setNewColumnMetadataList(List<PgsqlColumnMetadata> newColumnMetadataList) {
        this.newColumnMetadataList = newColumnMetadataList;
    }

    public void setDropIndexList(List<String> dropIndexList) {
        this.dropIndexList = dropIndexList;
    }

    public void setIndexMetadataList(List<PgsqlIndexMetadata> indexMetadataList) {
        this.indexMetadataList = indexMetadataList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PgsqlCompareTableInfo)) {
            return false;
        }
        PgsqlCompareTableInfo other = (PgsqlCompareTableInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        List<PgsqlColumnMetadata> this$newPrimaries = this.getNewPrimaries();
        List<PgsqlColumnMetadata> other$newPrimaries = other.getNewPrimaries();
        if (this$newPrimaries == null ? other$newPrimaries != null : !((Object)this$newPrimaries).equals(other$newPrimaries)) {
            return false;
        }
        String this$dropPrimaryKeyName = this.getDropPrimaryKeyName();
        String other$dropPrimaryKeyName = other.getDropPrimaryKeyName();
        if (this$dropPrimaryKeyName == null ? other$dropPrimaryKeyName != null : !this$dropPrimaryKeyName.equals(other$dropPrimaryKeyName)) {
            return false;
        }
        Map<String, String> this$columnComment = this.getColumnComment();
        Map<String, String> other$columnComment = other.getColumnComment();
        if (this$columnComment == null ? other$columnComment != null : !((Object)this$columnComment).equals(other$columnComment)) {
            return false;
        }
        Map<String, String> this$indexComment = this.getIndexComment();
        Map<String, String> other$indexComment = other.getIndexComment();
        if (this$indexComment == null ? other$indexComment != null : !((Object)this$indexComment).equals(other$indexComment)) {
            return false;
        }
        List<String> this$dropColumnList = this.getDropColumnList();
        List<String> other$dropColumnList = other.getDropColumnList();
        if (this$dropColumnList == null ? other$dropColumnList != null : !((Object)this$dropColumnList).equals(other$dropColumnList)) {
            return false;
        }
        List<PgsqlColumnMetadata> this$modifyColumnMetadataList = this.getModifyColumnMetadataList();
        List<PgsqlColumnMetadata> other$modifyColumnMetadataList = other.getModifyColumnMetadataList();
        if (this$modifyColumnMetadataList == null ? other$modifyColumnMetadataList != null : !((Object)this$modifyColumnMetadataList).equals(other$modifyColumnMetadataList)) {
            return false;
        }
        List<PgsqlColumnMetadata> this$newColumnMetadataList = this.getNewColumnMetadataList();
        List<PgsqlColumnMetadata> other$newColumnMetadataList = other.getNewColumnMetadataList();
        if (this$newColumnMetadataList == null ? other$newColumnMetadataList != null : !((Object)this$newColumnMetadataList).equals(other$newColumnMetadataList)) {
            return false;
        }
        List<String> this$dropIndexList = this.getDropIndexList();
        List<String> other$dropIndexList = other.getDropIndexList();
        if (this$dropIndexList == null ? other$dropIndexList != null : !((Object)this$dropIndexList).equals(other$dropIndexList)) {
            return false;
        }
        List<PgsqlIndexMetadata> this$indexMetadataList = this.getIndexMetadataList();
        List<PgsqlIndexMetadata> other$indexMetadataList = other.getIndexMetadataList();
        return !(this$indexMetadataList == null ? other$indexMetadataList != null : !((Object)this$indexMetadataList).equals(other$indexMetadataList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PgsqlCompareTableInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        List<PgsqlColumnMetadata> $newPrimaries = this.getNewPrimaries();
        result = result * 59 + ($newPrimaries == null ? 43 : ((Object)$newPrimaries).hashCode());
        String $dropPrimaryKeyName = this.getDropPrimaryKeyName();
        result = result * 59 + ($dropPrimaryKeyName == null ? 43 : $dropPrimaryKeyName.hashCode());
        Map<String, String> $columnComment = this.getColumnComment();
        result = result * 59 + ($columnComment == null ? 43 : ((Object)$columnComment).hashCode());
        Map<String, String> $indexComment = this.getIndexComment();
        result = result * 59 + ($indexComment == null ? 43 : ((Object)$indexComment).hashCode());
        List<String> $dropColumnList = this.getDropColumnList();
        result = result * 59 + ($dropColumnList == null ? 43 : ((Object)$dropColumnList).hashCode());
        List<PgsqlColumnMetadata> $modifyColumnMetadataList = this.getModifyColumnMetadataList();
        result = result * 59 + ($modifyColumnMetadataList == null ? 43 : ((Object)$modifyColumnMetadataList).hashCode());
        List<PgsqlColumnMetadata> $newColumnMetadataList = this.getNewColumnMetadataList();
        result = result * 59 + ($newColumnMetadataList == null ? 43 : ((Object)$newColumnMetadataList).hashCode());
        List<String> $dropIndexList = this.getDropIndexList();
        result = result * 59 + ($dropIndexList == null ? 43 : ((Object)$dropIndexList).hashCode());
        List<PgsqlIndexMetadata> $indexMetadataList = this.getIndexMetadataList();
        result = result * 59 + ($indexMetadataList == null ? 43 : ((Object)$indexMetadataList).hashCode());
        return result;
    }

    public String toString() {
        return "PgsqlCompareTableInfo(name=" + this.getName() + ", comment=" + this.getComment() + ", newPrimaries=" + this.getNewPrimaries() + ", dropPrimaryKeyName=" + this.getDropPrimaryKeyName() + ", columnComment=" + this.getColumnComment() + ", indexComment=" + this.getIndexComment() + ", dropColumnList=" + this.getDropColumnList() + ", modifyColumnMetadataList=" + this.getModifyColumnMetadataList() + ", newColumnMetadataList=" + this.getNewColumnMetadataList() + ", dropIndexList=" + this.getDropIndexList() + ", indexMetadataList=" + this.getIndexMetadataList() + ")";
    }

    public PgsqlCompareTableInfo(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }
}

