/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.pgsql.data;

import com.tangzc.mpe.autotable.strategy.pgsql.data.enums.PgsqlDefaultTypeEnum;

public class PgsqlTypeAndLength {
    private Integer length;
    private Integer decimalLength;
    private String type;

    public PgsqlTypeAndLength(Integer length, Integer decimalLength, String type) {
        if (length != null && length >= 0) {
            this.length = length;
        }
        if (decimalLength != null && decimalLength >= 0) {
            this.decimalLength = decimalLength;
        }
        this.type = type;
    }

    public String getFullType() {
        Object typeAndLength = this.type;
        if (this.length != null) {
            typeAndLength = (String)typeAndLength + "(" + this.length;
            if (this.decimalLength != null) {
                typeAndLength = (String)typeAndLength + "," + this.decimalLength;
            }
            typeAndLength = (String)typeAndLength + ")";
        }
        return typeAndLength;
    }

    public String typeName() {
        return this.type.toLowerCase();
    }

    public boolean isCharString() {
        return PgsqlDefaultTypeEnum.CHAR.typeName().equalsIgnoreCase(this.typeName()) || PgsqlDefaultTypeEnum.VARCHAR.typeName().equalsIgnoreCase(this.typeName()) || PgsqlDefaultTypeEnum.TEXT.typeName().equalsIgnoreCase(this.typeName());
    }

    public boolean isBoolean() {
        return PgsqlDefaultTypeEnum.BOOL.typeName().equalsIgnoreCase(this.typeName());
    }

    public boolean isTime() {
        return PgsqlDefaultTypeEnum.DATE.typeName().equalsIgnoreCase(this.typeName()) || PgsqlDefaultTypeEnum.TIMESTAMP.typeName().equalsIgnoreCase(this.typeName()) || PgsqlDefaultTypeEnum.TIME.typeName().equalsIgnoreCase(this.typeName());
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getDecimalLength() {
        return this.decimalLength;
    }

    public String getType() {
        return this.type;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setDecimalLength(Integer decimalLength) {
        this.decimalLength = decimalLength;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PgsqlTypeAndLength)) {
            return false;
        }
        PgsqlTypeAndLength other = (PgsqlTypeAndLength)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        Integer this$decimalLength = this.getDecimalLength();
        Integer other$decimalLength = other.getDecimalLength();
        if (this$decimalLength == null ? other$decimalLength != null : !((Object)this$decimalLength).equals(other$decimalLength)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PgsqlTypeAndLength;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        Integer $decimalLength = this.getDecimalLength();
        result = result * 59 + ($decimalLength == null ? 43 : ((Object)$decimalLength).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "PgsqlTypeAndLength(length=" + this.getLength() + ", decimalLength=" + this.getDecimalLength() + ", type=" + this.getType() + ")";
    }

    public PgsqlTypeAndLength() {
    }
}

