/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.pgsql.mapper;

import com.baomidou.mybatisplus.annotation.InterceptorIgnore;
import com.tangzc.mpe.autotable.strategy.pgsql.data.dbdata.PgsqlDbColumn;
import com.tangzc.mpe.autotable.strategy.pgsql.data.dbdata.PgsqlDbIndex;
import com.tangzc.mpe.autotable.strategy.pgsql.data.dbdata.PgsqlDbPrimary;
import java.util.List;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;

@InterceptorIgnore(tenantLine="true", illegalSql="true", blockAttack="true")
public interface PgsqlTablesMapper {
    @Select(value={"${sql}"})
    public void executeSql(String var1);

    @Delete(value={"DROP TABLE IF EXISTS ${tableName}"})
    public void dropTableByName(String var1);

    @Select(value={"select count(*) from pg_class where relname = #{tableName}"})
    public int checkTableExist(String var1);

    @Select(value={"select description from pg_description where objoid=(select oid from pg_class where relname = #{tableName}) and objsubid=0"})
    public String selectTableDescription(String var1);

    @Results(value={@Result(column="primary", property="primary"), @Result(column="description", property="description"), @Result(column="table_catalog", property="tableCatalog"), @Result(column="table_schema", property="tableSchema"), @Result(column="table_name", property="tableName"), @Result(column="column_name", property="columnName"), @Result(column="ordinal_position", property="ordinalPosition"), @Result(column="column_default", property="columnDefault"), @Result(column="is_nullable", property="isNullable"), @Result(column="data_type", property="dataType"), @Result(column="character_maximum_length", property="characterMaximumLength"), @Result(column="character_octet_length", property="characterOctetLength"), @Result(column="numeric_precision", property="numericPrecision"), @Result(column="numeric_precision_radix", property="numericPrecisionRadix"), @Result(column="numeric_scale", property="numericScale"), @Result(column="datetime_precision", property="datetimePrecision"), @Result(column="interval_type", property="intervalType"), @Result(column="interval_precision", property="intervalPrecision"), @Result(column="character_set_catalog", property="characterSetCatalog"), @Result(column="character_set_schema", property="characterSetSchema"), @Result(column="character_set_name", property="characterSetName"), @Result(column="collation_catalog", property="collationCatalog"), @Result(column="collation_schema", property="collationSchema"), @Result(column="collation_name", property="collationName"), @Result(column="domain_catalog", property="domainCatalog"), @Result(column="domain_schema", property="domainSchema"), @Result(column="domain_name", property="domainName"), @Result(column="udt_catalog", property="udtCatalog"), @Result(column="udt_schema", property="udtSchema"), @Result(column="udt_name", property="udtName"), @Result(column="scope_catalog", property="scopeCatalog"), @Result(column="scope_schema", property="scopeSchema"), @Result(column="scope_name", property="scopeName"), @Result(column="maximum_cardinality", property="maximumCardinality"), @Result(column="dtd_identifier", property="dtdIdentifier"), @Result(column="is_self_referencing", property="isSelfReferencing"), @Result(column="is_identity", property="isIdentity"), @Result(column="identity_generation", property="identityGeneration"), @Result(column="identity_start", property="identityStart"), @Result(column="identity_increment", property="identityIncrement"), @Result(column="identity_maximum", property="identityMaximum"), @Result(column="identity_minimum", property="identityMinimum"), @Result(column="identity_cycle", property="identityCycle"), @Result(column="is_generated", property="isGenerated"), @Result(column="generation_expression", property="generationExpression"), @Result(column="is_updatable", property="isUpdatable")})
    @Select(value={"SELECT key_col.column_name is not null as primary, des.description, col.* FROM information_schema.columns col LEFT JOIN pg_description des on col.ordinal_position=des.objsubid and col.table_name::regclass=des.objoid LEFT JOIN information_schema.key_column_usage key_col on key_col.column_name = col.column_name and key_col.table_name = col.table_name WHERE col.table_name = #{tableName}"})
    public List<PgsqlDbColumn> selectTableFieldDetail(String var1);

    @Results(value={@Result(column="description", property="description"), @Result(column="schemaname", property="schemaName"), @Result(column="tablename", property="tableName"), @Result(column="indexname", property="indexName"), @Result(column="tablespace", property="tablespace"), @Result(column="indexdef", property="indexdef")})
    @Select(value={"SELECT d.description,idx.* FROM pg_indexes idx LEFT JOIN pg_description d ON idx.indexname::regclass = d.objoid WHERE idx.tablename = #{tableName}"})
    public List<PgsqlDbIndex> selectTableIndexesDetail(String var1);

    @Results(value={@Result(column="primary_name", property="primaryName"), @Result(column="columns", property="columns")})
    @Select(value={"SELECT constraint_name as primary_name, string_agg(column_name, ',' ORDER BY ordinal_position ASC) as columns FROM information_schema.key_column_usage WHERE table_name = #{tableName} GROUP BY constraint_name limit 1"})
    public PgsqlDbPrimary selectPrimaryKeyName(String var1);
}

