/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.sqlite;

import com.tangzc.mpe.autotable.constants.DatabaseDialect;
import com.tangzc.mpe.autotable.strategy.IStrategy;
import com.tangzc.mpe.autotable.strategy.sqlite.builder.CreateTableSqlBuilder;
import com.tangzc.mpe.autotable.strategy.sqlite.builder.TableMetadataBuilder;
import com.tangzc.mpe.autotable.strategy.sqlite.data.SqliteCompareTableInfo;
import com.tangzc.mpe.autotable.strategy.sqlite.data.SqliteIndexMetadata;
import com.tangzc.mpe.autotable.strategy.sqlite.data.SqliteTableMetadata;
import com.tangzc.mpe.autotable.strategy.sqlite.data.dbdata.SqliteMaster;
import com.tangzc.mpe.autotable.strategy.sqlite.mapper.SqliteTablesMapper;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class SqliteStrategy
implements IStrategy<SqliteTableMetadata, SqliteCompareTableInfo> {
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    @Resource
    private SqliteTablesMapper sqliteTablesMapper;

    @Override
    public DatabaseDialect dbDialect() {
        return DatabaseDialect.SQLite;
    }

    @Override
    public void dropTable(String tableName) {
        this.sqliteTablesMapper.dropTableByName(tableName);
    }

    @Override
    public boolean checkTableExist(String tableName) {
        int i = this.sqliteTablesMapper.checkTableExist(tableName);
        return i > 0;
    }

    @Override
    public SqliteTableMetadata analyseClass(Class<?> beanClass) {
        SqliteTableMetadata sqliteTableMetadata = TableMetadataBuilder.build(beanClass);
        if (sqliteTableMetadata.getColumnMetadataList().isEmpty()) {
            log.warn("\u626b\u63cf\u53d1\u73b0{}\u6ca1\u6709\u5efa\u8868\u5b57\u6bb5\u8bf7\u68c0\u67e5\uff01", (Object)beanClass.getName());
            return null;
        }
        return sqliteTableMetadata;
    }

    @Override
    public void createTable(SqliteTableMetadata tableMetadata) {
        String createTableSql = CreateTableSqlBuilder.buildTableSql(tableMetadata.getTableName(), tableMetadata.getComment(), tableMetadata.getColumnMetadataList());
        this.sqliteTablesMapper.executeSql(createTableSql);
        List<String> createIndexSqlList = CreateTableSqlBuilder.buildIndexSql(tableMetadata.getTableName(), tableMetadata.getIndexMetadataList());
        for (String createIndexSql : createIndexSqlList) {
            this.sqliteTablesMapper.executeSql(createIndexSql);
        }
    }

    @Override
    public SqliteCompareTableInfo compareTable(SqliteTableMetadata tableMetadata) {
        boolean needRebuildTable;
        String tableName = tableMetadata.getTableName();
        SqliteCompareTableInfo sqliteCompareTableInfo = new SqliteCompareTableInfo(tableName);
        String orgBuildTableSql = this.sqliteTablesMapper.queryBuildTableSql(tableName);
        String newBuildTableSql = CreateTableSqlBuilder.buildTableSql(tableMetadata.getTableName(), tableMetadata.getComment(), tableMetadata.getColumnMetadataList());
        boolean bl = needRebuildTable = !Objects.equals(orgBuildTableSql + ";", newBuildTableSql);
        if (needRebuildTable) {
            sqliteCompareTableInfo.setRebuildTableSql(newBuildTableSql);
            List<SqliteMaster> orgBuildIndexSqlList = this.sqliteTablesMapper.queryBuildIndexSql(tableName);
            for (SqliteMaster sqliteMaster : orgBuildIndexSqlList) {
                sqliteCompareTableInfo.getDeleteIndexList().add(sqliteMaster.getName());
            }
            List<String> buildIndexSqlList = CreateTableSqlBuilder.buildIndexSql(tableName, tableMetadata.getIndexMetadataList());
            for (String buildIndexSql : buildIndexSqlList) {
                sqliteCompareTableInfo.getBuildIndexSqlList().add(buildIndexSql);
            }
        } else {
            Map<String, String> rebuildIndexMap = tableMetadata.getIndexMetadataList().stream().collect(Collectors.toMap(SqliteIndexMetadata::getName, indexMetadata -> CreateTableSqlBuilder.getIndexSql(tableName, indexMetadata)));
            List<SqliteMaster> orgBuildIndexSqlList = this.sqliteTablesMapper.queryBuildIndexSql(tableName);
            for (SqliteMaster sqliteMaster : orgBuildIndexSqlList) {
                boolean exit;
                String indexName = sqliteMaster.getName();
                String newBuildIndexSql = rebuildIndexMap.remove(indexName);
                boolean bl2 = exit = newBuildIndexSql != null;
                if (!exit) {
                    sqliteCompareTableInfo.getDeleteIndexList().add(indexName);
                }
                String createIndexSqlRecord = sqliteMaster.getSql() + ";";
                if (!exit || Objects.equals(newBuildIndexSql, createIndexSqlRecord)) continue;
                sqliteCompareTableInfo.getDeleteIndexList().add(indexName);
                sqliteCompareTableInfo.getBuildIndexSqlList().add(newBuildIndexSql);
            }
            Map<String, String> map = rebuildIndexMap;
            if (!map.isEmpty()) {
                sqliteCompareTableInfo.getBuildIndexSqlList().addAll(map.values());
            }
        }
        return sqliteCompareTableInfo;
    }

    @Override
    public void modifyTable(SqliteCompareTableInfo sqliteCompareTableInfo) {
        List<String> buildIndexSqlList;
        String rebuildTableSql;
        List<String> deleteIndexList = sqliteCompareTableInfo.getDeleteIndexList();
        if (!deleteIndexList.isEmpty()) {
            for (String deleteIndexName : deleteIndexList) {
                this.sqliteTablesMapper.dropIndexSql(deleteIndexName);
            }
        }
        if (StringUtils.hasText((String)(rebuildTableSql = sqliteCompareTableInfo.getRebuildTableSql()))) {
            String orgTableName = sqliteCompareTableInfo.getName();
            String backupTableName = this.getBackupTableName(orgTableName);
            this.sqliteTablesMapper.backupTable(orgTableName, backupTableName);
            this.sqliteTablesMapper.executeSql(rebuildTableSql);
            this.sqliteTablesMapper.migrateData(orgTableName, backupTableName);
        }
        if (!(buildIndexSqlList = sqliteCompareTableInfo.getBuildIndexSqlList()).isEmpty()) {
            for (String buildIndexSql : buildIndexSqlList) {
                this.sqliteTablesMapper.executeSql(buildIndexSql);
            }
        }
    }

    private String getBackupTableName(String orgTableName) {
        int offset = 0;
        String backupName = "_" + orgTableName + "_old_" + LocalDateTime.now().format(this.dateTimeFormatter);
        while (true) {
            int count;
            if (offset > 0) {
                backupName = backupName + "_" + offset;
            }
            if ((count = this.sqliteTablesMapper.checkTableExist(backupName)) == 0) {
                return backupName;
            }
            ++offset;
        }
    }
}

