/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.sqlite.builder;

import com.tangzc.mpe.autotable.annotation.enums.IndexTypeEnum;
import com.tangzc.mpe.autotable.strategy.sqlite.data.SqliteColumnMetadata;
import com.tangzc.mpe.autotable.strategy.sqlite.data.SqliteIndexMetadata;
import com.tangzc.mpe.autotable.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class CreateTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(CreateTableSqlBuilder.class);

    public static String buildTableSql(String name, String comment, List<SqliteColumnMetadata> columnMetadataList) {
        ArrayList<String> primaries = new ArrayList<String>();
        columnMetadataList.forEach(columnData -> {
            if (columnData.isPrimary()) {
                columnData.setNotNull(true);
                primaries.add(columnData.getName());
            }
        });
        boolean isSinglePrimaryKey = primaries.size() == 1;
        boolean hasPrimaries = !primaries.isEmpty() && !isSinglePrimaryKey;
        ArrayList<String> addItems = new ArrayList<String>();
        AtomicInteger count = new AtomicInteger(0);
        addItems.add(columnMetadataList.stream().map(columnData -> {
            boolean isNotLastItem = count.incrementAndGet() < columnMetadataList.size();
            return columnData.toColumnSql(isSinglePrimaryKey, isNotLastItem || hasPrimaries);
        }).collect(Collectors.joining("\n")));
        if (hasPrimaries) {
            String primaryKeySql = CreateTableSqlBuilder.getPrimaryKeySql(primaries);
            addItems.add(primaryKeySql);
        }
        String addSql = addItems.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        return "CREATE TABLE `{tableName}` -- {comment} \n(\n{addItems}\n);".replace("{tableName}", name).replace("{comment}", comment).replace("{addItems}", addSql);
    }

    public static List<String> buildIndexSql(String name, List<SqliteIndexMetadata> indexMetadataList) {
        return indexMetadataList.stream().map(indexMetadata -> CreateTableSqlBuilder.getIndexSql(name, indexMetadata)).sorted().collect(Collectors.toList());
    }

    public static String getIndexSql(String tableName, SqliteIndexMetadata sqliteIndexMetadata) {
        return StringHelper.newInstance("CREATE{indexType} INDEX \"{indexName}\" ON {tableName} ({columns}) {indexComment};").replace("{indexType}", (String)(sqliteIndexMetadata.getType() == IndexTypeEnum.NORMAL ? "" : " " + sqliteIndexMetadata.getType().name())).replace("{indexName}", sqliteIndexMetadata.getName()).replace("{tableName}", tableName).replace("{columns}", key -> {
            List<SqliteIndexMetadata.IndexColumnParam> columnParams = sqliteIndexMetadata.getColumns();
            return columnParams.stream().map(column -> "\"{column}\" {sortMode}".replace("{column}", column.getColumn()).replace("{sortMode}", column.getSort() != null ? column.getSort().name() : "")).collect(Collectors.joining(","));
        }).replace("{indexComment}", (String)(StringUtils.hasText((String)sqliteIndexMetadata.getComment()) ? "-- " + sqliteIndexMetadata.getComment() : "")).toString();
    }

    private static String getPrimaryKeySql(List<String> primaries) {
        return "PRIMARY KEY ({primaries})".replace("{primaries}", primaries.stream().map(fieldName -> "\"" + fieldName + "\"").collect(Collectors.joining(",")));
    }
}

