/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.sqlite.converter.impl;

import com.tangzc.mpe.autotable.strategy.sqlite.converter.JavaToSqliteConverter;
import com.tangzc.mpe.autotable.strategy.sqlite.data.SqliteTypeAndLength;
import com.tangzc.mpe.autotable.strategy.sqlite.data.enums.SqliteDefaultTypeEnum;
import com.tangzc.mpe.magic.util.EnumUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;

public class DefaultJavaToSqliteConverter
implements JavaToSqliteConverter {
    private static final Map<Class<?>, SqliteDefaultTypeEnum> JAVA_TO_SQLITE_TYPE_MAP = new HashMap<Class<?>, SqliteDefaultTypeEnum>(){
        {
            this.put(String.class, SqliteDefaultTypeEnum.TEXT);
            this.put(Character.class, SqliteDefaultTypeEnum.TEXT);
            this.put(Character.TYPE, SqliteDefaultTypeEnum.TEXT);
            this.put(BigInteger.class, SqliteDefaultTypeEnum.INTEGER);
            this.put(Long.class, SqliteDefaultTypeEnum.INTEGER);
            this.put(Long.TYPE, SqliteDefaultTypeEnum.INTEGER);
            this.put(Integer.class, SqliteDefaultTypeEnum.INTEGER);
            this.put(Integer.TYPE, SqliteDefaultTypeEnum.INTEGER);
            this.put(Boolean.class, SqliteDefaultTypeEnum.INTEGER);
            this.put(Boolean.TYPE, SqliteDefaultTypeEnum.INTEGER);
            this.put(Float.class, SqliteDefaultTypeEnum.REAL);
            this.put(Float.TYPE, SqliteDefaultTypeEnum.REAL);
            this.put(Double.class, SqliteDefaultTypeEnum.REAL);
            this.put(Double.TYPE, SqliteDefaultTypeEnum.REAL);
            this.put(BigDecimal.class, SqliteDefaultTypeEnum.REAL);
            this.put(java.util.Date.class, SqliteDefaultTypeEnum.TEXT);
            this.put(Date.class, SqliteDefaultTypeEnum.TEXT);
            this.put(Timestamp.class, SqliteDefaultTypeEnum.TEXT);
            this.put(Time.class, SqliteDefaultTypeEnum.TEXT);
            this.put(LocalDateTime.class, SqliteDefaultTypeEnum.TEXT);
            this.put(LocalDate.class, SqliteDefaultTypeEnum.TEXT);
            this.put(LocalTime.class, SqliteDefaultTypeEnum.TEXT);
            this.put(Short.class, SqliteDefaultTypeEnum.INTEGER);
            this.put(Short.TYPE, SqliteDefaultTypeEnum.INTEGER);
        }
    };

    @Override
    public SqliteTypeAndLength convert(Class<?> fieldClass) {
        SqliteDefaultTypeEnum sqlType;
        if (fieldClass.isEnum()) {
            fieldClass = EnumUtil.getEnumFieldSaveDbType(fieldClass);
        }
        if ((sqlType = JAVA_TO_SQLITE_TYPE_MAP.getOrDefault(fieldClass, SqliteDefaultTypeEnum.TEXT)) == null) {
            throw new RuntimeException(fieldClass + "\u9ed8\u8ba4\u60c5\u51b5\u4e0b\uff0c\u4e0d\u652f\u6301\u8f6c\u6362\u5230sqlite\u7c7b\u578b\uff0c\u5982\u6709\u9700\u8981\u8bf7\u81ea\u884c\u5b9e\u73b0" + JavaToSqliteConverter.class.getName());
        }
        return new SqliteTypeAndLength(sqlType.getLengthDefault(), sqlType.getDecimalLengthDefault(), sqlType.typeName());
    }
}

