/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.sqlite.data;

import com.tangzc.mpe.autotable.annotation.ColumnDefault;
import com.tangzc.mpe.autotable.annotation.ColumnType;
import com.tangzc.mpe.autotable.annotation.enums.DefaultValueEnum;
import com.tangzc.mpe.autotable.strategy.sqlite.converter.JavaToSqliteConverter;
import com.tangzc.mpe.autotable.strategy.sqlite.data.SqliteTypeAndLength;
import com.tangzc.mpe.autotable.utils.StringHelper;
import com.tangzc.mpe.autotable.utils.TableBeanUtils;
import com.tangzc.mpe.magic.TableColumnNameUtil;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SqliteColumnMetadata {
    private static final Logger log = LoggerFactory.getLogger(SqliteColumnMetadata.class);
    private String name;
    private String comment;
    private SqliteTypeAndLength type;
    private boolean notNull;
    private boolean autoIncrement;
    private DefaultValueEnum defaultValueType;
    private String defaultValue;
    private boolean primary;

    public static SqliteColumnMetadata create(Class<?> clazz, Field field) {
        SqliteColumnMetadata sqliteColumnMetadata = new SqliteColumnMetadata();
        sqliteColumnMetadata.setName(TableColumnNameUtil.getRealColumnName((Field)field));
        ColumnType columnType = TableBeanUtils.getColumnType(field);
        if (columnType != null && StringUtils.hasText((String)columnType.value())) {
            SqliteTypeAndLength sqliteTypeAndLength = new SqliteTypeAndLength(columnType.length(), columnType.decimalLength(), columnType.value());
            sqliteColumnMetadata.setType(sqliteTypeAndLength);
        } else {
            Class<?> fieldType = TableBeanUtils.getFieldType(clazz, field);
            JavaToSqliteConverter javaToSqliteConverter = (JavaToSqliteConverter)SpringContextUtil.getBeanOfType(JavaToSqliteConverter.class);
            sqliteColumnMetadata.setType(javaToSqliteConverter.convert(fieldType));
        }
        sqliteColumnMetadata.setNotNull(TableBeanUtils.isNotNull(field));
        sqliteColumnMetadata.setPrimary(TableBeanUtils.isPrimary(field));
        sqliteColumnMetadata.setAutoIncrement(TableBeanUtils.isAutoIncrement(field));
        ColumnDefault columnDefault = TableBeanUtils.getDefaultValue(field);
        if (columnDefault != null) {
            boolean isBooleanType;
            sqliteColumnMetadata.setDefaultValueType(columnDefault.type());
            Object defaultValue = columnDefault.value();
            Class<?> fieldType = field.getType();
            boolean bl = isBooleanType = (fieldType == Boolean.class || fieldType == Boolean.TYPE) && sqliteColumnMetadata.getType().isInteger();
            if (isBooleanType && !"1".equals(defaultValue) && !"0".equals(defaultValue)) {
                defaultValue = Boolean.parseBoolean((String)defaultValue) ? "1" : "0";
            }
            if (sqliteColumnMetadata.getType().isText() && !((String)defaultValue).isEmpty() && !((String)defaultValue).startsWith("'") && !((String)defaultValue).endsWith("'")) {
                defaultValue = "'" + (String)defaultValue + "'";
            }
            sqliteColumnMetadata.setDefaultValue((String)defaultValue);
        }
        sqliteColumnMetadata.setComment(TableBeanUtils.getComment(field));
        return sqliteColumnMetadata;
    }

    public String toColumnSql(boolean isSinglePrimaryKey, boolean addComma) {
        return StringHelper.newInstance("\"{columnName}\" {typeAndLength} {null} {default} {primaryKey}{comma}{columnComment}").replace("{columnName}", this.getName()).replace("{typeAndLength}", this.type.getFullType()).replace("{null}", this.isNotNull() ? "NOT NULL" : "NULL").replace("{default}", key -> {
            DefaultValueEnum defaultValueType = this.getDefaultValueType();
            if (defaultValueType == DefaultValueEnum.NULL) {
                return "DEFAULT NULL";
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return "DEFAULT ''";
            }
            String defaultValue = this.getDefaultValue();
            if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText((String)defaultValue)) {
                return "DEFAULT " + defaultValue;
            }
            return "";
        }).replace("{primaryKey}", key -> {
            if (isSinglePrimaryKey && this.isPrimary() && this.isAutoIncrement()) {
                return "PRIMARY KEY AUTOINCREMENT";
            }
            return "";
        }).replace("{comma}", addComma ? "," : "").replace("{columnComment}", (String)(StringUtils.hasText((String)this.getComment()) ? " -- " + this.getComment() : "")).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public SqliteTypeAndLength getType() {
        return this.type;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public DefaultValueEnum getDefaultValueType() {
        return this.defaultValueType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setType(SqliteTypeAndLength type) {
        this.type = type;
    }

    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public void setDefaultValueType(DefaultValueEnum defaultValueType) {
        this.defaultValueType = defaultValueType;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqliteColumnMetadata)) {
            return false;
        }
        SqliteColumnMetadata other = (SqliteColumnMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNotNull() != other.isNotNull()) {
            return false;
        }
        if (this.isAutoIncrement() != other.isAutoIncrement()) {
            return false;
        }
        if (this.isPrimary() != other.isPrimary()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        SqliteTypeAndLength this$type = this.getType();
        SqliteTypeAndLength other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        DefaultValueEnum this$defaultValueType = this.getDefaultValueType();
        DefaultValueEnum other$defaultValueType = other.getDefaultValueType();
        if (this$defaultValueType == null ? other$defaultValueType != null : !this$defaultValueType.equals(other$defaultValueType)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqliteColumnMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotNull() ? 79 : 97);
        result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
        result = result * 59 + (this.isPrimary() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        SqliteTypeAndLength $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        DefaultValueEnum $defaultValueType = this.getDefaultValueType();
        result = result * 59 + ($defaultValueType == null ? 43 : $defaultValueType.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }

    public String toString() {
        return "SqliteColumnMetadata(name=" + this.getName() + ", comment=" + this.getComment() + ", type=" + this.getType() + ", notNull=" + this.isNotNull() + ", autoIncrement=" + this.isAutoIncrement() + ", defaultValueType=" + this.getDefaultValueType() + ", defaultValue=" + this.getDefaultValue() + ", primary=" + this.isPrimary() + ")";
    }
}

