/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.sqlite.data;

import com.tangzc.mpe.autotable.annotation.Index;
import com.tangzc.mpe.autotable.annotation.IndexField;
import com.tangzc.mpe.autotable.annotation.TableIndex;
import com.tangzc.mpe.autotable.annotation.enums.IndexSortTypeEnum;
import com.tangzc.mpe.autotable.annotation.enums.IndexTypeEnum;
import com.tangzc.mpe.magic.TableColumnNameUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;

public class SqliteIndexMetadata {
    private String name;
    private List<IndexColumnParam> columns = new ArrayList<IndexColumnParam>();
    private IndexTypeEnum type;
    private String comment;

    public static SqliteIndexMetadata create(Field field, String indexPrefix) {
        Index index = (Index)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, Index.class);
        if (null != index) {
            String realColumnName = TableColumnNameUtil.getRealColumnName((Field)field);
            SqliteIndexMetadata sqliteIndexMetadata = new SqliteIndexMetadata();
            String indexName = index.name();
            if (!StringUtils.hasText((String)indexName)) {
                indexName = TableColumnNameUtil.getRealColumnName((Field)field);
            }
            sqliteIndexMetadata.setName(indexPrefix + indexName);
            sqliteIndexMetadata.setType(index.type());
            sqliteIndexMetadata.setComment(index.comment());
            sqliteIndexMetadata.getColumns().add(IndexColumnParam.of(realColumnName, null));
            return sqliteIndexMetadata;
        }
        return null;
    }

    public static SqliteIndexMetadata create(Class<?> clazz, TableIndex tableIndex, String indexPrefix) {
        if (null != tableIndex) {
            List<IndexColumnParam> columnParams = SqliteIndexMetadata.getColumnParams(clazz, tableIndex);
            SqliteIndexMetadata sqliteIndexMetadata = new SqliteIndexMetadata();
            sqliteIndexMetadata.setName(indexPrefix + tableIndex.name());
            sqliteIndexMetadata.setType(tableIndex.type());
            sqliteIndexMetadata.setComment(tableIndex.comment());
            sqliteIndexMetadata.setColumns(columnParams);
            return sqliteIndexMetadata;
        }
        return null;
    }

    private static List<IndexColumnParam> getColumnParams(Class<?> clazz, TableIndex tableIndex) {
        String[] fields;
        ArrayList<IndexColumnParam> columnParams = new ArrayList<IndexColumnParam>();
        HashSet exitsColumns = new HashSet();
        IndexField[] sortFields = tableIndex.indexFields();
        if (sortFields.length > 0) {
            columnParams.addAll(Arrays.stream(sortFields).map(sortField -> {
                String realColumnName = TableColumnNameUtil.getRealColumnName((Class)clazz, (String)sortField.field());
                if (exitsColumns.contains(realColumnName)) {
                    return null;
                }
                exitsColumns.add(realColumnName);
                return IndexColumnParam.of(realColumnName, sortField.sort());
            }).filter(Objects::nonNull).toList());
        }
        if ((fields = tableIndex.fields()).length > 0) {
            columnParams.addAll(Arrays.stream(fields).map(field -> {
                String realColumnName = TableColumnNameUtil.getRealColumnName((Class)clazz, (String)field);
                if (exitsColumns.contains(realColumnName)) {
                    return null;
                }
                exitsColumns.add(realColumnName);
                return IndexColumnParam.of(realColumnName, null);
            }).filter(Objects::nonNull).toList());
        }
        return columnParams;
    }

    public String getName() {
        return this.name;
    }

    public List<IndexColumnParam> getColumns() {
        return this.columns;
    }

    public IndexTypeEnum getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public SqliteIndexMetadata setName(String name) {
        this.name = name;
        return this;
    }

    public SqliteIndexMetadata setColumns(List<IndexColumnParam> columns) {
        this.columns = columns;
        return this;
    }

    public SqliteIndexMetadata setType(IndexTypeEnum type) {
        this.type = type;
        return this;
    }

    public SqliteIndexMetadata setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqliteIndexMetadata)) {
            return false;
        }
        SqliteIndexMetadata other = (SqliteIndexMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<IndexColumnParam> this$columns = this.getColumns();
        List<IndexColumnParam> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !((Object)this$columns).equals(other$columns)) {
            return false;
        }
        IndexTypeEnum this$type = this.getType();
        IndexTypeEnum other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqliteIndexMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<IndexColumnParam> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : ((Object)$columns).hashCode());
        IndexTypeEnum $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        return result;
    }

    public String toString() {
        return "SqliteIndexMetadata(name=" + this.getName() + ", columns=" + this.getColumns() + ", type=" + this.getType() + ", comment=" + this.getComment() + ")";
    }

    public static class IndexColumnParam {
        private String column;
        private IndexSortTypeEnum sort;

        public String getColumn() {
            return this.column;
        }

        public IndexSortTypeEnum getSort() {
            return this.sort;
        }

        public IndexColumnParam setColumn(String column) {
            this.column = column;
            return this;
        }

        public IndexColumnParam setSort(IndexSortTypeEnum sort) {
            this.sort = sort;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexColumnParam)) {
                return false;
            }
            IndexColumnParam other = (IndexColumnParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$column = this.getColumn();
            String other$column = other.getColumn();
            if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
                return false;
            }
            IndexSortTypeEnum this$sort = this.getSort();
            IndexSortTypeEnum other$sort = other.getSort();
            return !(this$sort == null ? other$sort != null : !this$sort.equals(other$sort));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IndexColumnParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : $column.hashCode());
            IndexSortTypeEnum $sort = this.getSort();
            result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
            return result;
        }

        public String toString() {
            return "SqliteIndexMetadata.IndexColumnParam(column=" + this.getColumn() + ", sort=" + this.getSort() + ")";
        }

        private IndexColumnParam(String column, IndexSortTypeEnum sort) {
            this.column = column;
            this.sort = sort;
        }

        public static IndexColumnParam of(String column, IndexSortTypeEnum sort) {
            return new IndexColumnParam(column, sort);
        }
    }
}

