/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.strategy.sqlite.data;

import com.tangzc.mpe.autotable.strategy.sqlite.data.enums.SqliteDefaultTypeEnum;

public class SqliteTypeAndLength {
    private Integer length;
    private Integer decimalLength;
    private String type;

    public SqliteTypeAndLength(Integer length, Integer decimalLength, String type) {
        this.length = length;
        this.decimalLength = decimalLength;
        String upperName = type.toUpperCase();
        if (upperName.contains("INT")) {
            type = "INTEGER";
        }
        if (upperName.contains("CHAR") || upperName.contains("CLOB") || upperName.contains("TEXT")) {
            type = "TEXT";
        }
        if (upperName.contains("BLOB")) {
            type = "BLOB";
        }
        if (upperName.contains("REAL") || upperName.contains("FLOA") || upperName.contains("DOUB")) {
            type = "REAL";
        }
        this.type = type;
    }

    public String getFullType() {
        Object typeAndLength = this.type;
        if (this.length != null && this.length > 0) {
            typeAndLength = (String)typeAndLength + "(" + this.length;
            if (this.decimalLength != null && this.decimalLength > 0) {
                typeAndLength = (String)typeAndLength + "," + this.decimalLength;
            }
            typeAndLength = (String)typeAndLength + ")";
        }
        return typeAndLength;
    }

    public boolean isText() {
        return SqliteDefaultTypeEnum.TEXT.typeName().equalsIgnoreCase(this.type);
    }

    public boolean isInteger() {
        return SqliteDefaultTypeEnum.INTEGER.typeName().equalsIgnoreCase(this.type);
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getDecimalLength() {
        return this.decimalLength;
    }

    public String getType() {
        return this.type;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setDecimalLength(Integer decimalLength) {
        this.decimalLength = decimalLength;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqliteTypeAndLength)) {
            return false;
        }
        SqliteTypeAndLength other = (SqliteTypeAndLength)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        Integer this$decimalLength = this.getDecimalLength();
        Integer other$decimalLength = other.getDecimalLength();
        if (this$decimalLength == null ? other$decimalLength != null : !((Object)this$decimalLength).equals(other$decimalLength)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqliteTypeAndLength;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        Integer $decimalLength = this.getDecimalLength();
        result = result * 59 + ($decimalLength == null ? 43 : ((Object)$decimalLength).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "SqliteTypeAndLength(length=" + this.getLength() + ", decimalLength=" + this.getDecimalLength() + ", type=" + this.getType() + ")";
    }

    public SqliteTypeAndLength() {
    }
}

