/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable.utils;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.tangzc.mpe.autotable.annotation.ColumnComment;
import com.tangzc.mpe.autotable.annotation.ColumnDefault;
import com.tangzc.mpe.autotable.annotation.ColumnType;
import com.tangzc.mpe.autotable.annotation.NotNull;
import com.tangzc.mpe.autotable.annotation.Table;
import com.tangzc.mpe.autotable.annotation.TableIndex;
import com.tangzc.mpe.autotable.annotation.TableIndexes;
import com.tangzc.mpe.autotable.strategy.FieldTypeHandler;
import com.tangzc.mpe.autotable.strategy.IgnoreExt;
import com.tangzc.mpe.magic.AnnotatedElementUtilsPlus;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.annotation.AnnotatedElementUtils;

public class TableBeanUtils {
    private static Map<Class<?>, Set<String>> excludeFieldsMap = new HashMap();
    private static List<IgnoreExt> ignoreExts;
    private static List<FieldTypeHandler> fieldTypeHandlers;

    public static boolean isIncludeField(Field field, Class<?> clazz) {
        if (ignoreExts == null) {
            ignoreExts = SpringContextUtil.getBeansOfTypeList(IgnoreExt.class);
        }
        for (IgnoreExt ignoreExt : ignoreExts) {
            boolean isIgnoreField = ignoreExt.isIgnoreField(field, clazz);
            if (!isIgnoreField) continue;
            return false;
        }
        Set excludeFields = excludeFieldsMap.computeIfAbsent(clazz, k -> {
            Set<Object> excludes = new HashSet();
            Table table = (Table)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, Table.class);
            if (table != null) {
                excludes = Set.of(table.excludeProperty());
            }
            return excludes;
        });
        return !excludeFields.contains(field.getName());
    }

    public static List<TableIndex> getTableIndexes(Class<?> clazz) {
        TableIndex tableIndex;
        ArrayList<TableIndex> tableIndices = new ArrayList<TableIndex>();
        TableIndexes tableIndexes = (TableIndexes)AnnotatedElementUtils.findMergedAnnotation(clazz, TableIndexes.class);
        if (tableIndexes != null) {
            Collections.addAll(tableIndices, tableIndexes.value());
        }
        if ((tableIndex = (TableIndex)AnnotatedElementUtils.findMergedAnnotation(clazz, TableIndex.class)) != null) {
            tableIndices.add(tableIndex);
        }
        return tableIndices;
    }

    public static boolean isPrimary(Field field) {
        if (AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, TableId.class) != null) {
            return true;
        }
        return "id".equals(field.getName());
    }

    public static boolean isAutoIncrement(Field field) {
        TableId tableId = (TableId)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, TableId.class);
        return tableId != null && tableId.type() == IdType.AUTO;
    }

    public static Boolean isNotNull(Field field) {
        if (TableBeanUtils.isPrimary(field)) {
            return true;
        }
        NotNull column = (NotNull)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, NotNull.class);
        if (column != null) {
            return column.value();
        }
        return false;
    }

    public static String getComment(Field field) {
        ColumnComment column = (ColumnComment)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, ColumnComment.class);
        if (column != null) {
            return column.value();
        }
        return "";
    }

    public static ColumnDefault getDefaultValue(Field field) {
        return (ColumnDefault)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, ColumnDefault.class);
    }

    public static ColumnType getColumnType(Field field) {
        return (ColumnType)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, ColumnType.class);
    }

    public static Class<?> getFieldType(Class<?> clazz, Field field) {
        Class<?> fieldType;
        if (fieldTypeHandlers == null) {
            fieldTypeHandlers = SpringContextUtil.getBeansOfTypeList(FieldTypeHandler.class);
        }
        if ((fieldType = (Class<?>)fieldTypeHandlers.stream().map(handler -> handler.getFieldType(clazz, field)).filter(Objects::nonNull).findFirst().orElse(null)) == null) {
            fieldType = field.getType();
        }
        return fieldType;
    }
}

