/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tangzc.autotable.core.AutoTableOrmFrameAdapter;
import com.tangzc.mpe.annotation.handler.FieldDateTypeHandler;
import com.tangzc.mpe.autotable.IgnoreExt;
import com.tangzc.mpe.autotable.annotation.Table;
import com.tangzc.mpe.magic.MybatisPlusProperties;
import com.tangzc.mpe.magic.util.AnnotatedElementUtilsPlus;
import com.tangzc.mpe.magic.util.EnumUtil;
import com.tangzc.mpe.magic.util.TableColumnNameUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.ibatis.type.UnknownTypeHandler;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;

public class MybatisPlusAdapter
implements AutoTableOrmFrameAdapter {
    private final List<IgnoreExt> ignoreExts;
    private final List<FieldDateTypeHandler> fieldDateTypeHandlers;

    public MybatisPlusAdapter(List<IgnoreExt> ignoreExts, List<FieldDateTypeHandler> fieldDateTypeHandlers) {
        this.ignoreExts = ignoreExts;
        this.fieldDateTypeHandlers = fieldDateTypeHandlers;
    }

    public boolean isIgnoreField(Field field, Class<?> clazz) {
        boolean ignore;
        TableField tableField = (TableField)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, TableField.class);
        boolean bl = ignore = tableField != null && !tableField.exist();
        if (ignore) {
            return true;
        }
        TableName tableName = (TableName)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, TableName.class);
        if (tableName != null) {
            return Arrays.stream(tableName.excludeProperty()).anyMatch(property -> property.equals(field.getName()));
        }
        for (IgnoreExt ignoreExt : this.ignoreExts) {
            boolean isIgnoreField = ignoreExt.isIgnoreField(field, clazz);
            if (!isIgnoreField) continue;
            return false;
        }
        return false;
    }

    public boolean isPrimary(Field field, Class<?> clazz) {
        if (AnnotatedElementUtils.isAnnotated((AnnotatedElement)field, TableId.class)) {
            return true;
        }
        return "id".equals(field.getName());
    }

    public boolean isAutoIncrement(Field field, Class<?> clazz) {
        if (!this.isPrimary(field, clazz)) {
            return false;
        }
        TableId tableId = (TableId)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)field, TableId.class);
        return tableId != null && tableId.type() == IdType.AUTO;
    }

    public Class<?> customFieldTypeHandler(Class<?> clazz, Field field) {
        if (field.getType().isEnum()) {
            return EnumUtil.getEnumFieldSaveDbType(field.getType());
        }
        TableField column = (TableField)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, TableField.class);
        if (column != null && column.typeHandler() != UnknownTypeHandler.class) {
            return String.class;
        }
        Class<?> fieldType = this.fieldDateTypeHandlers.stream().map(handler -> handler.getDateType(clazz, field)).filter(Objects::nonNull).findFirst().orElse(null);
        if (fieldType == null) {
            fieldType = field.getType();
        }
        return fieldType;
    }

    public List<String> getEnumValues(Class<?> enumClassType) {
        if (enumClassType.isEnum()) {
            Field valField = Arrays.stream(enumClassType.getDeclaredFields()).filter(field -> field.isAnnotationPresent(EnumValue.class)).findFirst().orElse(null);
            if (valField != null) {
                valField.setAccessible(true);
                return Arrays.stream(enumClassType.getEnumConstants()).map(enumConstant -> {
                    try {
                        return valField.get(enumConstant);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }).map(Objects::toString).collect(Collectors.toList());
            }
            return Arrays.stream(enumClassType.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
        }
        throw new IllegalArgumentException(String.format("Class: %s \u975e\u679a\u4e3e\u7c7b\u578b", enumClassType.getName()));
    }

    public List<Class<? extends Annotation>> scannerAnnotations() {
        return Arrays.asList(Table.class, TableName.class);
    }

    public String getTableName(Class<?> clazz) {
        return TableColumnNameUtil.getTableName(clazz);
    }

    public String getTableSchema(Class<?> clazz) {
        TableName mybatisPlusTableName = (TableName)AnnotatedElementUtilsPlus.findDeepMergedAnnotation(clazz, TableName.class);
        if (mybatisPlusTableName != null && StringUtils.hasText((String)mybatisPlusTableName.schema())) {
            return mybatisPlusTableName.schema();
        }
        return null;
    }

    public String getRealColumnName(Class<?> clazz, Field field) {
        TableField tableField = (TableField)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, TableField.class);
        if (tableField != null && StringUtils.hasText((String)tableField.value()) && tableField.exist()) {
            return MybatisPlusAdapter.filterSpecialChar(tableField.value());
        }
        TableId tableId = (TableId)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)field, TableId.class);
        if (tableId != null && StringUtils.hasText((String)tableId.value())) {
            return MybatisPlusAdapter.filterSpecialChar(tableId.value());
        }
        return MybatisPlusAdapter.smartConvert(MybatisPlusProperties.mapUnderscoreToCamelCase, field.getName());
    }

    private static String filterSpecialChar(String name) {
        return name.replaceAll("`", "");
    }

    public static String smartConvert(Boolean camelToUnderline, String column) {
        if (camelToUnderline != null && camelToUnderline.booleanValue()) {
            column = com.baomidou.mybatisplus.core.toolkit.StringUtils.camelToUnderline((String)column);
        }
        if (MybatisPlusProperties.capitalMode) {
            column = column.toUpperCase();
        }
        return column;
    }
}

