/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.autotable;

import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.tangzc.autotable.core.dynamicds.IDataSourceHandler;
import com.tangzc.mpe.autotable.annotation.Table;
import com.tangzc.mpe.magic.util.AnnotatedElementUtilsPlus;
import java.lang.reflect.AnnotatedElement;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

@ConditionalOnClass(value={DynamicDataSourceProperties.class})
@ConditionalOnProperty(prefix="spring.datasource.dynamic", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class DynamicDatasourceHandler
implements IDataSourceHandler {
    private static final Logger log = LoggerFactory.getLogger(DynamicDatasourceHandler.class);
    @Autowired
    private DynamicDataSourceProperties dynamicDataSourceProperties;

    public void useDataSource(String dsName) {
        DynamicDataSourceContextHolder.push((String)dsName);
    }

    public void clearDataSource(String serializable) {
        DynamicDataSourceContextHolder.poll();
    }

    @NonNull
    public String getDataSourceName(Class clazz) {
        Table tableAnno = (Table)AnnotatedElementUtilsPlus.findDeepMergedAnnotation((AnnotatedElement)clazz, Table.class);
        if (tableAnno != null) {
            return tableAnno.dsName();
        }
        return this.dynamicDataSourceProperties.getPrimary();
    }
}

