/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.base.repository;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.repository.CrudRepository;
import com.tangzc.mpe.base.event.EntityUpdateEvent;
import com.tangzc.mpe.base.repository.IBaseRepository;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import java.util.Collection;

public abstract class BaseRepository<M extends BaseMapper<E>, E>
extends CrudRepository<M, E>
implements IBaseRepository<E> {
    public boolean updateById(E entity) {
        boolean result = super.updateById(entity);
        if (result) {
            SpringContextUtil.publishEvent(EntityUpdateEvent.create(entity, new SFunction[0]));
        }
        return result;
    }

    public boolean updateBatchById(Collection<E> entityList, int batchSize) {
        boolean result = super.updateBatchById(entityList, batchSize);
        if (result) {
            for (E entity : entityList) {
                SpringContextUtil.publishEvent(EntityUpdateEvent.create(entity, new SFunction[0]));
            }
        }
        return result;
    }
}

