/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.bind.builder;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.tangzc.mpe.base.MapperScanner;
import com.tangzc.mpe.bind.builder.QueryWrapperBuilder;
import com.tangzc.mpe.bind.metadata.FieldDescription;
import com.tangzc.mpe.bind.metadata.JoinConditionDescription;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class ResultBuilder<BEAN, ENTITY> {
    private final List<BEAN> beans;
    private final FieldDescription.ConditionSign<ENTITY, JoinConditionDescription> conditionSign;
    private final List<? extends FieldDescription<?, JoinConditionDescription>> fieldDescriptions;
    private final FillDataCallback fillDataCallback;

    public void fillData() {
        Map<String, List<ENTITY>> entityMap = this.listEntitiesByCondition();
        for (BEAN bean : this.beans) {
            String entryGroupKey = this.getConditionSignatureBySelf(bean, this.conditionSign);
            List entities = entityMap.getOrDefault(entryGroupKey, Collections.emptyList());
            for (FieldDescription<?, JoinConditionDescription> fieldAnnotation : this.fieldDescriptions) {
                List<Object> dataList = entities;
                if (this.fillDataCallback != null) {
                    this.fillDataCallback.fillBefore(bean, fieldAnnotation, dataList);
                    dataList = this.fillDataCallback.changeDataList(bean, fieldAnnotation, dataList);
                }
                this.fullDataToBeanField(bean, fieldAnnotation, dataList);
            }
        }
    }

    private Map<String, List<ENTITY>> listEntitiesByCondition() {
        String lastSql = this.conditionSign.getLast();
        List<Object> entities = new ArrayList();
        if (StringUtils.hasText((String)lastSql)) {
            for (BEAN bean : this.beans) {
                List<BEAN> beanList = Collections.singletonList(bean);
                entities.addAll(this.listEntitiesByCondition(beanList));
            }
        } else {
            entities = this.listEntitiesByCondition(this.beans);
        }
        return entities.stream().collect(Collectors.groupingBy(entity -> this.getConditionSignatureByJoin(entity, this.conditionSign)));
    }

    private List<ENTITY> listEntitiesByCondition(List<BEAN> beanList) {
        QueryWrapper queryWrapper = QueryWrapperBuilder.newInstance().select(this.fillDataCallback.selectColumns(beanList, this.conditionSign, this.fieldDescriptions)).where(this.conditionSign.getConditions(), this.conditionSign.getCustomCondition()).orderBy(this.conditionSign.getOrderBys()).last(this.conditionSign.getLast()).build(beanList);
        Class<ENTITY> joinEntityClass = this.conditionSign.getJoinEntityClass();
        return (List)MapperScanner.getMapperExecute(joinEntityClass, (SFunction & Serializable)mapper -> mapper.selectList((Wrapper)queryWrapper));
    }

    private void fullDataToBeanField(BEAN bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> dataList) {
        List<?> val;
        if (fieldAnnotation.isCollection()) {
            val = dataList;
        } else {
            this.checkBindDataSize(bean.getClass().getName(), dataList.size(), fieldAnnotation.getFieldName());
            val = dataList.isEmpty() ? null : dataList.get(0);
        }
        try {
            fieldAnnotation.getSetMethod().invoke(bean, val);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("\u5b57\u6bb5" + fieldAnnotation.getFieldName() + "\u8bbe\u7f6e\u503c\u5931\u8d25\u3002", e);
        }
    }

    private void checkBindDataSize(String beanName, int dataListSize, String fieldName) {
        if (dataListSize > 1) {
            String entityName = this.conditionSign.getJoinEntityClass().getName();
            throw new RuntimeException(beanName + "." + fieldName + "\u5173\u8054" + entityName + "\u7684\u6570\u636e\u6761\u6570\u5927\u4e8e1\u6761");
        }
    }

    private String getConditionSignatureBySelf(BEAN bean, FieldDescription.ConditionSign<ENTITY, JoinConditionDescription> conditionSign) {
        return conditionSign.getConditions().stream().map(condition -> {
            try {
                return condition.getJoinFieldName() + "=" + String.valueOf(condition.getSelfFieldGetMethod().invoke(bean, new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.joining("|"));
    }

    private String getConditionSignatureByJoin(ENTITY entity, FieldDescription.ConditionSign<ENTITY, JoinConditionDescription> conditionSign) {
        return conditionSign.getConditions().stream().map(condition -> {
            try {
                return condition.getJoinFieldName() + "=" + String.valueOf(condition.getJoinFieldGetMethod().invoke(entity, new Object[0]));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.joining("|"));
    }

    private ResultBuilder(List<BEAN> beans, FieldDescription.ConditionSign<ENTITY, JoinConditionDescription> conditionSign, List<? extends FieldDescription<?, JoinConditionDescription>> fieldDescriptions, FillDataCallback fillDataCallback) {
        this.beans = beans;
        this.conditionSign = conditionSign;
        this.fieldDescriptions = fieldDescriptions;
        this.fillDataCallback = fillDataCallback;
    }

    public static <BEAN, ENTITY> ResultBuilder<BEAN, ENTITY> newInstance(List<BEAN> beans, FieldDescription.ConditionSign<ENTITY, JoinConditionDescription> conditionSign, List<? extends FieldDescription<?, JoinConditionDescription>> fieldDescriptions, FillDataCallback fillDataCallback) {
        return new ResultBuilder<BEAN, ENTITY>(beans, conditionSign, fieldDescriptions, fillDataCallback);
    }

    public static interface FillDataCallback {
        default public String[] selectColumns(List<?> beans, FieldDescription.ConditionSign<?, JoinConditionDescription> entityJoinCondition, List<? extends FieldDescription<?, JoinConditionDescription>> fieldAnnotationList) {
            return null;
        }

        default public void fillBefore(Object bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> entities) {
        }

        default public List<?> changeDataList(Object bean, FieldDescription<?, JoinConditionDescription> fieldAnnotation, List<?> entities) {
            return entities;
        }
    }
}

