/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.bind.manager;

import com.tangzc.mpe.bind.metadata.BeanDescription;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanAnnotationManager {
    public static final Map<String, BeanDescription<?>> BEAN_ANNOTATION_CACHE_MAP = new ConcurrentHashMap();

    public static <BEAN> BeanDescription<BEAN> getBeanAnnotation(Class<BEAN> beanClass, List<String> includeField, List<String> ignoreField) {
        CharSequence[] keys = new String[]{beanClass.getName(), String.join((CharSequence)",", includeField), String.join((CharSequence)",", ignoreField)};
        String key = String.join((CharSequence)"#", keys);
        return BEAN_ANNOTATION_CACHE_MAP.computeIfAbsent(key, k -> BeanAnnotationManager.initBeanAnnotation(beanClass, includeField, ignoreField));
    }

    private static <BEAN> BeanDescription<BEAN> initBeanAnnotation(Class<BEAN> beanClass, List<String> includeField, List<String> ignoreField) {
        BeanDescription<BEAN> beanAnnotation = new BeanDescription<BEAN>(beanClass);
        List<Field> fieldList = BeanAnnotationManager.extractAllFields(beanClass);
        HashSet<String> ignoreFieldSet = new HashSet<String>(ignoreField);
        HashSet<String> includeFieldSet = new HashSet<String>(includeField);
        for (Field field : fieldList) {
            if (!includeFieldSet.isEmpty() && !includeFieldSet.contains(field.getName()) || includeFieldSet.isEmpty() && ignoreFieldSet.contains(field.getName())) continue;
            beanAnnotation.findBindAnnotation(field);
        }
        return beanAnnotation;
    }

    private static List<Field> extractAllFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashSet fieldNameSet = new HashSet();
        while (clazz != null && clazz != Object.class) {
            Field[] fields = clazz.getDeclaredFields();
            Arrays.stream(fields).forEach(field -> {
                if (!fieldNameSet.contains(field.getName())) {
                    fieldList.add((Field)field);
                    fieldNameSet.add(field.getName());
                }
            });
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }
}

