/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.bind.metadata;

import com.tangzc.mpe.bind.metadata.OrderByDescription;
import com.tangzc.mpe.magic.util.BeanClassUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public abstract class FieldDescription<BIND_ANNOTATION extends Annotation, CONDITION_DESC> {
    protected Field field;
    protected Class<?> fieldClass;
    protected Method setMethod;
    protected boolean isCollection;
    protected BIND_ANNOTATION bindAnnotation;
    protected Class<?> entityClass;
    protected String customCondition;
    protected List<OrderByDescription> orderBys;
    protected String last;

    public FieldDescription(Field field, Method setMethod, boolean isCollection, BIND_ANNOTATION bindAnnotation, Class<?> entityClass, String customCondition, List<OrderByDescription> orderBys, String last) {
        this.field = field;
        this.fieldClass = BeanClassUtil.getFieldRealClass((Field)field);
        this.setMethod = setMethod;
        this.isCollection = isCollection;
        this.bindAnnotation = bindAnnotation;
        this.entityClass = entityClass;
        this.customCondition = customCondition;
        this.orderBys = orderBys.stream().distinct().collect(Collectors.toList());
        this.last = last;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public abstract ConditionSign<?, CONDITION_DESC> conditionUniqueKey();

    public Field getField() {
        return this.field;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public Method getSetMethod() {
        return this.setMethod;
    }

    public boolean isCollection() {
        return this.isCollection;
    }

    public BIND_ANNOTATION getBindAnnotation() {
        return this.bindAnnotation;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getCustomCondition() {
        return this.customCondition;
    }

    public List<OrderByDescription> getOrderBys() {
        return this.orderBys;
    }

    public String getLast() {
        return this.last;
    }

    public static class ConditionSign<ENTITY, CONDITION_DESC>
    implements Serializable {
        private final Class<ENTITY> joinEntityClass;
        private final List<CONDITION_DESC> conditions;
        private final String customCondition;
        private final List<OrderByDescription> orderBys;
        private final String last;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConditionSign that = (ConditionSign)o;
            String thisConditions = this.getSortConditionStr();
            String thisOrderBys = this.getSortOrderByStr();
            String thatConditions = that.getSortConditionStr();
            String thatCustomCondition = that.getCustomCondition();
            String thatOrderBys = that.getSortOrderByStr();
            String thatLast = that.getLast();
            if (StringUtils.hasText((String)this.last) || StringUtils.hasText((String)thatLast)) {
                return false;
            }
            return this.joinEntityClass.equals(that.joinEntityClass) && thisConditions.equals(thatConditions) && this.customCondition.equals(thatCustomCondition) && thisOrderBys.equals(thatOrderBys) && this.last.equals(thatLast);
        }

        public int hashCode() {
            return Objects.hash(this.joinEntityClass, this.getSortConditionStr(), this.customCondition, this.getSortOrderByStr(), this.last);
        }

        private String getSortConditionStr() {
            return this.conditions.stream().map(Object::toString).sorted().collect(Collectors.joining("#"));
        }

        private String getSortOrderByStr() {
            return this.orderBys.stream().map(Object::toString).sorted().collect(Collectors.joining("#"));
        }

        public Class<ENTITY> getJoinEntityClass() {
            return this.joinEntityClass;
        }

        public List<CONDITION_DESC> getConditions() {
            return this.conditions;
        }

        public String getCustomCondition() {
            return this.customCondition;
        }

        public List<OrderByDescription> getOrderBys() {
            return this.orderBys;
        }

        public String getLast() {
            return this.last;
        }

        public ConditionSign(Class<ENTITY> joinEntityClass, List<CONDITION_DESC> conditions, String customCondition, List<OrderByDescription> orderBys, String last) {
            this.joinEntityClass = joinEntityClass;
            this.conditions = conditions;
            this.customCondition = customCondition;
            this.orderBys = orderBys;
            this.last = last;
        }
    }
}

