/*
 * Decompiled with CFR 0.152.
 */
package com.tangzc.mpe.condition;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.tangzc.mpe.condition.DynamicConditionManager;
import com.tangzc.mpe.condition.metadata.DynamicConditionDescription;
import com.tangzc.mpe.condition.metadata.IDynamicConditionHandler;
import com.tangzc.mpe.magic.util.EnumUtil;
import com.tangzc.mpe.magic.util.SpringContextUtil;
import com.tangzc.mpe.magic.util.TableColumnNameUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicConditionInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicConditionInterceptor.class);

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBs.sql(this.changeSql(mpBs.sql()));
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE) {
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            mpBs.sql(this.changeSql(mpBs.sql()));
        }
    }

    protected String changeSql(String sql) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            return this.processParser(statement, 0, sql, null);
        }
        catch (JSQLParserException jSQLParserException) {
            return sql;
        }
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        String tableName = TableColumnNameUtil.filterSpecialChar((String)delete.getTable().getName());
        List<DynamicConditionDescription> descriptions = DynamicConditionManager.getDynamicCondition(tableName);
        if (descriptions == null) {
            return;
        }
        Expression where = this.getExpression(descriptions, delete.getWhere());
        delete.setWhere(where);
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        String tableName = TableColumnNameUtil.filterSpecialChar((String)update.getTable().getName());
        List<DynamicConditionDescription> descriptions = DynamicConditionManager.getDynamicCondition(tableName);
        if (descriptions == null) {
            return;
        }
        Expression where = this.getExpression(descriptions, update.getWhere());
        update.setWhere(where);
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        this.processSelectBody(select);
    }

    private void processSelectBody(Select select) {
        if (select instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)select);
        } else if (select instanceof WithItem) {
            WithItem withItem = (WithItem)select;
            Select subSelect = withItem.getSelect();
            if (subSelect != null) {
                this.processSelectBody(subSelect);
            }
        } else {
            SetOperationList operationList = (SetOperationList)select;
            if (operationList.getSelects() != null && !operationList.getSelects().isEmpty()) {
                operationList.getSelects().forEach(this::processSelectBody);
            }
        }
    }

    private void processPlainSelect(PlainSelect plainSelect) {
        FromItem fromItem = plainSelect.getFromItem();
        if (fromItem instanceof Table) {
            String tableName = TableColumnNameUtil.filterSpecialChar((String)((Table)fromItem).getName());
            List<DynamicConditionDescription> descriptions = DynamicConditionManager.getDynamicCondition(tableName);
            if (descriptions == null) {
                return;
            }
            Expression where = this.getExpression(descriptions, plainSelect.getWhere());
            plainSelect.setWhere(where);
        }
    }

    private Expression getExpression(List<DynamicConditionDescription> descriptions, Expression where) {
        try {
            for (DynamicConditionDescription description : descriptions) {
                Field entityField = description.getEntityField();
                Class handlerClass = description.getDynamicCondition().value();
                IDynamicConditionHandler conditionHandler = (IDynamicConditionHandler)SpringContextUtil.getBeanOfType((Class)handlerClass);
                if (!conditionHandler.enable()) continue;
                List<Object> values = conditionHandler.values();
                String realColumnName = TableColumnNameUtil.getRealColumnName((Field)entityField);
                String condExpr = values == null || values.isEmpty() ? realColumnName + " is null" : ((values = DynamicConditionInterceptor.autoFillStrVal(entityField, values)).size() == 1 ? realColumnName + "=" + String.valueOf(values.get(0)) : realColumnName + " in(" + values.stream().map(Object::toString).collect(Collectors.joining(",")) + ")");
                Expression envCondition = CCJSqlParserUtil.parseCondExpression((String)condExpr);
                if (where == null) {
                    where = envCondition;
                    continue;
                }
                where = new AndExpression(where, envCondition);
            }
        }
        catch (JSQLParserException e) {
            log.error("\u52a8\u6001\u6761\u4ef6\u6dfb\u52a0\u5931\u8d25", (Throwable)e);
        }
        return where;
    }

    private static List<Object> autoFillStrVal(Field entityField, List<Object> values) {
        Class type = entityField.getType();
        if (type.isEnum()) {
            type = EnumUtil.getEnumFieldSaveDbType(type);
        }
        if (type == String.class) {
            values = values.stream().map(value -> {
                String valStr = value.toString();
                if (valStr.startsWith("'") && valStr.endsWith("'")) {
                    return valStr;
                }
                return "'" + valStr + "'";
            }).collect(Collectors.toList());
        }
        return values;
    }
}

